/*
 * File: ControllablePlayer.java
 */

package model.interfaces.selectable;

import model.Location;

/**
 * Allows the controller to get information about a player and its units, as
 * well as execute some commands specific to the player.
 * 
 * @author Christopher Dudley
 */
public interface ControllablePlayer
{
    
    /**
     * Tells the player to create a new rally point with a given ID. This will
     * not change the game state if a rally point of this ID already exists, or
     * the ID is out of range.
     * 
     * @param rallyPointID
     *            the ID number of the rally point to create.
     */
    public void createRallyPoint( int rallyPointID );
    
    /**
     * Returns a list of the various groups of selectable game construct types.
     * 
     * @return a list of selectable groups.
     */
    public SelectableGroup[] getGroups();
    
    /**
     * Returns the location of the specified selectable instance as a Point.
     * 
     * @param inst
     *            the selectable instance of which to get the location.
     * 
     * @return the location of the instance as a Point if it exists, null
     *         otherwise.
     */
    public Location getInstLocation( SelectableInstance inst );
    
    /**
     * Returns an array of the various army rally points under the player's
     * control.
     * 
     * @return an array of rally points.
     */
    public SelectableRallyPoint[] getRallyPoints();
    
    /**
     * Returns an array of the various structures under the player's control.
     * 
     * @return an array of structures.
     */
    public SelectableStructure[] getStructures();
}
