/*
 * File: InstanceTypeAndHealth.java
 */

package model.interfaces.selectable;

import model.InstanceType;

/**
 * Used to determine the type and current health of a unit or structure so that
 * this information can be reported to the outside world.
 * 
 * @author Christopher Dudley
 */
public interface InstanceTypeAndHealth
{
    
    /**
     * Returns the percentage health of the unit or structure for which this is
     * reporting.
     * 
     * @return percentage health of the unit/structure.
     */
    public int getPercentHealth();
    
    /**
     * Returns the enumerated type of the unit/structure.
     * 
     * @return enumerated type of the unit/structure.
     */
    public InstanceType getType();
}
