/*
 * File: SelectableGroup.java
 */

package model.interfaces.selectable;

/**
 * Allows controllers to query for information about an overall group of
 * selectable things owned by a player and the types it contains.
 * 
 * @author Christopher Dudley
 */
public interface SelectableGroup
{
    
    /**
     * Returns the name of the group as a string.
     * 
     * @author Christopher Dudley
     * 
     * @return the name of the group.
     */
    public String getName();
    
    /**
     * Returns an array of the different selectable types of things in this
     * group.
     * 
     * @author Christopher Dudley
     * 
     * @return the different types in the group.
     */
    public SelectableType[] getTypes();
}
