/*
 * Files: SelectableRallyPoint.java
 */

package model.interfaces.selectable;

//note:
//Controller wants list of selectableInstances 
//wants:
//getAllUnits
//getReinforcemts
//get BattleGroup
//perhaps put these in interface SelectableRallyPoint?

/**
 * Allows controller and view access to information about a selectable Rally
 * Point's Id and current queue, as well as allowing the army it represents to
 * be disbanded.
 * 
 * @author Christopher Dudley
 */
public interface SelectableRallyPoint
{
    
    /**
     * Disbands the army that the rally point belongs to.
     */
    public void disband();
    
    /**
     * Returns the ID number of the rally point.
     * 
     * @return the rally point's ID number.
     */
    public int getID();
    
    /**
     * Returns the command queue associated with that rally point as an array of
     * selectable commands.
     * 
     * @return the rally point's command queue.
     */
    public SelectableCommand[] getQueue();
}
