/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package view;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.awt.Graphics2D;

/**
 * 
 * @author spock
 */
class MainScreen
{
    
    private static final int APPWIDTH = 800;
    private static final int APPHEIGHT = 600;
    
    private BufferedImage imageBuffer; // contains the image of the mainScreen
    private HUD hud; // contains the hud's image info
    private ViewPort viewPort; // contains the viewPort's image info
    
    private Graphics2D graphix;
    
    // constructor
    MainScreen() {
        imageBuffer = new BufferedImage( APPWIDTH, APPHEIGHT, BufferedImage.TYPE_INT_ARGB );
        WritableRaster raster = imageBuffer.copyData( null );
        BufferedImage copy = new BufferedImage( imageBuffer.getColorModel(), raster,
                imageBuffer.isAlphaPremultiplied(), null );
        viewPort = new ViewPort();
        // viewPort.refreshImage();
        hud = new HUD();
        hud.refreshImage();
        
        graphix = (Graphics2D) copy.getGraphics();
        graphix.drawImage( hud.getImage(), 0, 450, null );
        graphix.drawImage( viewPort.getImage(), 0, 0, null );
        imageBuffer = copy;
    }
    
    // returns the current HUD
    HUD getHUD()
    {
        return hud;
    }
    
    // returns the current viewport
    ViewPort getViewPort()
    {
        return viewPort;
    }
    
    // updates the viewport
    void updateViewPort()
    {
        viewPort.refreshImage();
        refreshImage();
    }
    
    // updates the hud
    void updateHUD()
    {
        hud.refreshImage();
        refreshImage();
    }
    
    // refreshes the viewport and the hud
    void refreshImage()
    {
        imageBuffer = new BufferedImage( APPWIDTH, APPHEIGHT, BufferedImage.TYPE_INT_ARGB );
        graphix = (Graphics2D) imageBuffer.getGraphics();
        graphix.drawImage( hud.getImage(), 0, 450, null );
        graphix.drawImage( viewPort.getImage(), 0, 0, null );
    }
    
    // returns the image of the MainScreen
    BufferedImage getImage()
    {
        return imageBuffer;
    }
    
}
