package view;

import java.awt.image.BufferedImage;
import javax.swing.JApplet;
import java.awt.event.KeyListener;
import java.awt.BorderLayout;
import javax.swing.JFrame;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.swing.JLabel;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

/**
 * 
 * @author spock
 */
class ScreenManager extends JApplet
{
    
    private BufferedImage imageBuffer; // main image
    private Overview overview; // overview
    private CommandQueueOverview commandQueueOverview; // command queue overview
    private MainScreen mainScreen; // main screen
    private boolean showOverview = false; // toggle overview
    private boolean showCommandQueueOverview = false; // toggle command queue
                                                      // overview
    
    private static final int APPWIDTH = 800;// width
    private static final int APPHEIGHT = 600; // height
    public static final long serialVersionUID = 1L; // to avoid warnings
    
    Graphics2D graphix; // graphics object
    
    private static KeyListener listen; // listener for frame
    
    private static JFrame frame; // main frame
    
    // constructor
    // overrides init
    public void init()
    {
        getContentPane().setLayout( new BorderLayout() );
        frame = new JFrame( "Random Terrain Septic" );
        frame.setDefaultCloseOperation( JFrame.EXIT_ON_CLOSE );
        setPreferredSize( new Dimension( APPWIDTH, APPHEIGHT ) );
        imageBuffer = new BufferedImage( APPWIDTH, APPHEIGHT, BufferedImage.TYPE_INT_ARGB );
        
        mainScreen = new MainScreen();
        // View.initMap();
        // (mainScreen.getViewPort()).refreshImage();
        mainScreen.refreshImage();
        
        overview = new Overview();
        overview.refreshImage();
        
        commandQueueOverview = new CommandQueueOverview();
        commandQueueOverview.refreshImage();
        
        graphix = (Graphics2D) imageBuffer.getGraphics();
        graphix.drawImage( mainScreen.getImage(), 0, 0, this );
        if ( showOverview )
        {
            graphix.drawImage( overview.getImage(), 480, 0, this );
            if ( showCommandQueueOverview )
            {
                graphix.drawImage( commandQueueOverview.getImage(), 230, 40, this );
            }
        }
        SwingUtilities.invokeLater( new Runnable()
        {
            public void run()
            {
                
                displayBufferedImage( imageBuffer );
                
            }
        } );
        
    }
    
    // returns the fram of the manager applet
    JFrame getFrame()
    {
        return frame;
    }
    
    // returns the current mainscreen
    MainScreen getMainScreen()
    {
        return mainScreen;
    }
    
    // returns the current overview
    Overview getOverview()
    {
        return overview;
    }
    
    // returns the current command queue overview
    CommandQueueOverview getCommandQueueOverview()
    {
        return commandQueueOverview;
    }
    
    // refreshes the overall screen
    void refreshMe()
    {
        imageBuffer = new BufferedImage( APPWIDTH, APPHEIGHT, BufferedImage.TYPE_INT_ARGB );
        graphix = (Graphics2D) imageBuffer.getGraphics();
        
        graphix.drawImage( mainScreen.getImage(), 0, 0, null );
        
        if ( showOverview )
        {
            graphix.drawImage( overview.getImage(), 480, 20, null );
            if ( showCommandQueueOverview )
            {
                graphix.drawImage( commandQueueOverview.getImage(), 230, 40, null );
            }
        }
        SwingUtilities.invokeLater( new Runnable()
        {
            public void run()
            {
                
                displayBufferedImage( imageBuffer );
                
            }
        } );
    }
    
    // method used to actually display the image
    private void displayBufferedImage( BufferedImage image )
    {
        this.setContentPane( new JLabel( new ImageIcon( image ) ) );
        this.validate();
    }
    
    // hides the overview from the screen
    void hideOverview()
    {
        showOverview = false;
    }
    
    // shows the overview to the screen
    void showOverview()
    {
        showOverview = true;
    }
    
    // hides the command queue overview
    void hideCommandQueueOverview()
    {
        showCommandQueueOverview = false;
    }
    
    // shows the command queue overview
    void showCommandQueueOverview( String[] commands )
    {
        if ( showOverview )
        {
            showCommandQueueOverview = true;
            commandQueueOverview.setCommands( commands );
        }
    }
    
    // returns the image of the ScreenManager the time
    BufferedImage getImage()
    {
        return null;
    }
    
}
