package com.ouroboroswiki.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public abstract class AbstractProxiedContent implements Content {

	protected Content proxied;
	
	public AbstractProxiedContent( Content proxied ) {
		this.proxied = proxied;
	}
	
	@Override
	public boolean exists() {
		return proxied.exists();
	}

	@Override
	public Map<String, Content> getChildContent() {
		return proxied.getChildContent();
	}
	
	public Content getChildContent( String name ) {
		return proxied.getChildContent(name);
	}

	@Override
	public String getMimeType() {
		return proxied.getMimeType();
	}

	@Override
	public String getRepositoryName() {
		return proxied.getRepositoryName();
	}

	@Override
	public String getUniqueName() {
		return proxied.getUniqueName();
	}

	@Override
	public User getUpdateEditor() {
		return proxied.getUpdateEditor();
	}

	@Override
	public Date getUpdateTime() {
		return proxied.getUpdateTime();
	}

	@Override
	public Object getVersion() {
		return proxied.getVersion();
	}

	@Override
	public boolean isDynamic() {
		return proxied.isDynamic();
	}

	@Override
	public boolean isReadable() {
		return proxied.isReadable();
	}

	@Override
	public boolean isWritable() {
		return proxied.isWritable();
	}

	@Override
	public void write( OutputStream outs ) throws IOException, ContentException {
		proxied.write( outs );
	}
	
	@Override
	public Collection<ContentValidationResult> getValidationResults() {
		return this.proxied.getValidationResults();
	}

}
