package com.ouroboroswiki.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public interface Content {
	
	public static final String CHILD_CONTENT_MAIN = "main";
	public static final String OUROBOROS_NS_URL = "http://www.ouroboroswiki.com/ext";
	public static final String OUROBOROS_NS_PREFIX = "our";
	
	String getUniqueName();
	
	String getRepositoryName();
	
	String getMimeType();

	boolean exists();

	boolean isReadable();
	
	boolean isWritable();
	
	boolean isDynamic();
	
	void write(OutputStream outs) throws IOException, ContentException;
	
	Map<String, Content> getChildContent();
	
	Content getChildContent( String name );
	
	Object getVersion();
	
	User getUpdateEditor();
	
	Date getUpdateTime();
	
	Collection<ContentValidationResult> getValidationResults();
	
}
