package com.ouroboroswiki.core;


public class ContentException extends Exception {
	
	private static final long serialVersionUID = 0;
	
	private String[] uniqueNames;
	
	public ContentException() {
	}
	
	public ContentException( String message ) {
		super( message );
	}
	
	public ContentException( String message, Throwable cause ) {
		super( message, cause );
	}
	
	public ContentException(String[] uniqueNames) {
		this.uniqueNames = uniqueNames; 
	}
	
	public ContentException( String message, String[] uniqueNames ) {
		super( message );
		this.uniqueNames = uniqueNames;
	}
	
	public ContentException( String message, Throwable cause, String...uniqueNames ) {
		super( message, cause );
		this.uniqueNames = uniqueNames;
	}
	
	public String[] getUniqueNames() {
		return this.uniqueNames;
	}

}
