package com.ouroboroswiki.core;

public class ContentValidationResult {
	private Level level; 
	private String message;
	private Throwable error;
	
	public ContentValidationResult( Level level, String message ) {
		this( level, message, null );
	}
	
	public ContentValidationResult( Level level, String message, Throwable error ) {
		this.level = level;
		this.message = message;
		this.error = error;
	}
	
	public Level getLevel() {
		return this.level;
	}
	
	public String getMessage() {
		return this.message;
	}
	
	public Throwable getError() {
		return this.error;
	}
	
	public static enum Level {
		Info, 
		Hint,
		Warning, 
		Error
	}
}
