package com.ouroboroswiki.core.content;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ouroboroswiki.core.AbstractContentRepository;
import com.ouroboroswiki.core.Content;
import com.ouroboroswiki.core.ContentException;
import com.ouroboroswiki.core.ContentPath;
import com.ouroboroswiki.core.ContentRepository;
import com.ouroboroswiki.core.MultipartVersion;
import com.ouroboroswiki.core.Version;
import com.ouroboroswiki.core.VersionBuilder;

public class CompositeContentRepository extends AbstractContentRepository {

	private List<ContentRepository> repositories;
	private String mimeType;
	
	public CompositeContentRepository() {
	
	}
	
	public String getMimeType() {
		return mimeType;
	}

	public void setMimeType(String mimeType) {
		this.mimeType = mimeType;
	}

	public List<ContentRepository> getRepositories() {
		return repositories;
	}

	public void setRepositories(List<ContentRepository> repositories) {
		this.repositories = repositories;
	}

	@Override
	public Version buildVersion(Object principal, ContentPath path,
			String[] versionPath, VersionBuilder versionBuilder)
			throws ContentException {
		HashMap<String, Version> childVersions = new HashMap<String, Version>( repositories.size() );
		for( int i=0; i<repositories.size(); i++ ) {
			ContentRepository repository = repositories.get( i );
			String repositoryName = repository.getName();
			Version repositoryVersion = repository.buildVersion(principal, path, versionPath, versionBuilder);
			childVersions.put( repositoryName, repositoryVersion );
		}
		
		MultipartVersion result = new MultipartVersion(childVersions);
		return result;
	}

	@Override
	public boolean exists(Object principal, ContentPath path)
			throws ContentException {
		boolean exists = false;
		for( int i=0; i<repositories.size() && !exists; i++ ) {
			ContentRepository repository = (ContentRepository)repositories.get( i );
			exists = repository.exists(principal, path);
		}
		return exists;
	}

	@Override
	public Content getContent(Object principal, ContentPath path,
			Version version, Map<String, Object> properties)
			throws ContentException {
		MultipartVersion multipartVersion = (MultipartVersion)version;
		HashMap<String, Content> childContent = new HashMap<String, Content>( this.repositories.size() );
		boolean dynamic = false;
		boolean exists = false;
		for( int i=this.repositories.size(); i>0; ) {
			i--;
			ContentRepository repository = this.repositories.get( i );
			Version childVersion;
			if( multipartVersion != null ) {
				childVersion = multipartVersion.get(repository.getName());
			} else {
				childVersion = null;
			}
			Content content = repository.getContent(principal, path, childVersion, properties);
			dynamic = content.isDynamic() || dynamic;
			exists = content.exists() || exists;
			childContent.put( repository.getName(), content);
		}
		CompositeContent result = new CompositeContent(childContent);
		result.setDynamic(dynamic);
		result.setMimeType(this.mimeType);
		result.setWritable(false);
		result.setExists(exists);
		result.setUniqueName(path.getBaseName());
		result.setRepositoryName(this.getName());
		return result;
	}

}
