package com.ouroboroswiki.core.content;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

import com.ouroboroswiki.core.AbstractContent;
import com.ouroboroswiki.core.Content;
import com.ouroboroswiki.core.ContentException;
import com.ouroboroswiki.core.ContentPath;
import com.ouroboroswiki.core.ContentUtil;

public class PlaceholderContent extends AbstractContent {
	
	public PlaceholderContent( ContentPath path ) {
		this.setUniqueName(path.getBaseName());
		
		this.setRepositoryName( ContentUtil.toPipe(path) );
		this.setExists( true );
		this.setReadable(true);
	}

	@Override
	public Map<String, Content> getChildContent() {
		return new HashMap<String, Content>(0);
	}
	
	@Override
	public void write(OutputStream outs) throws IOException, ContentException {
		throw new ContentException( "placeholder only" );
	}

}
