package com.ouroboroswiki.core.content;

import java.util.Map;

import com.ouroboroswiki.core.AbstractContentRepository;
import com.ouroboroswiki.core.Content;
import com.ouroboroswiki.core.ContentException;
import com.ouroboroswiki.core.ContentPath;
import com.ouroboroswiki.core.ContentRepository;
import com.ouroboroswiki.core.Version;
import com.ouroboroswiki.core.VersionBuilder;

public class StaticPathContentRepositoryProxy extends AbstractContentRepository {

	private ContentPath hardCodedPath;
	private ContentRepository proxied;
	
	public StaticPathContentRepositoryProxy( String[] hardCodedPath, ContentRepository proxied ) {
		this.proxied = proxied;
		ContentPath path = null;
		for( int i=0; i<hardCodedPath.length; i++ ) {
			path = new ContentPath( hardCodedPath[i], path );
		}
		this.hardCodedPath = path;
	}
	
	public StaticPathContentRepositoryProxy( ContentPath hardCodedPath, ContentRepository proxied ) {
		this.hardCodedPath = hardCodedPath;
		this.proxied = proxied;
	}
	
	@Override
	public boolean exists(Object principal, ContentPath path) throws ContentException {
		return proxied.exists(principal, hardCodedPath);
	}

	@Override
	public Content getContent(Object principal, ContentPath path, Version version, Map<String, Object> properties)
			throws ContentException {
		return proxied.getContent(principal, hardCodedPath, version, properties);
	}

	@Override
	public Version buildVersion(Object principal, ContentPath path,
			String[] versionPath, VersionBuilder versionBuilder)
			throws ContentException {
		return proxied.buildVersion(principal, hardCodedPath, versionPath, versionBuilder);
	}
}
