package com.ouroboroswiki.core.content.markup.processor;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.ouroboroswiki.core.Content;
import com.ouroboroswiki.core.ContentPath;
import com.ouroboroswiki.core.ContentValidationResult;
import com.ouroboroswiki.core.Version;


public class FormContentMarkupHandler extends LinkContentMarkupHandler {

	public static final String ATTRIBUTE_ACTION			= "action";
	public static final String ATTRIBUTE_PARAMETER_NAME = "name";
	public static final String PARAMETER_ELEMENT_NAME   = "parameter";
	public static final String ATTRIBUTE_METHOD			= "method";
	
	public static final String FORM_NAME = "form";
	public static final String FORM_ACTION_NAME = "action";
	public static final String INPUT_ELEMENT_NAME = "input";
	public static final String INPUT_TYPE_NAME = "type";
	public static final String INPUT_TYPE_HIDDEN_VALUE = "hidden";
	public static final String INPUT_NAME_NAME = "name";
	public static final String INPUT_VALUE_NAME = "value";
	
	public FormContentMarkupHandler( String linkRoot ) {
		super( FORM_NAME, FORM_ACTION_NAME, linkRoot );
	}
	
	
	@Override
	public List<Node> replace(Object principal, Element e, Document parent,
			Map<String, Content> childContent, ContentPath currentPath,
			Version version, Collection<ContentValidationResult> validations, Map<String, Object> properties) throws IOException {
		List<Node> result = super.replace(principal, e, parent, childContent, currentPath, version, validations, properties);
		for( int i=0; i<result.size(); i++ ) {
			Element r = (Element)result.get( i );
			String method = r.getAttribute(ATTRIBUTE_METHOD);
			if( method == null || method.length() == 0 ) {
				r.setAttribute(ATTRIBUTE_METHOD, "post");
			}
			String actionName = e.getAttribute(ATTRIBUTE_ACTION);
			if( actionName != null && actionName.length() > 0 ) {
				Element inputElement = parent.createElement(INPUT_ELEMENT_NAME);
				inputElement.setAttribute(INPUT_TYPE_NAME, INPUT_TYPE_HIDDEN_VALUE);
				inputElement.setAttribute(INPUT_NAME_NAME, ATTRIBUTE_ACTION);
				inputElement.setAttribute(INPUT_VALUE_NAME, actionName);
				r.appendChild(inputElement);
			}
			NodeList parameters = r.getElementsByTagNameNS( Content.OUROBOROS_NS_URL, PARAMETER_ELEMENT_NAME );
			for( int j=parameters.getLength(); j>0; ) {
				j--;
				Element parameter = (Element)parameters.item(j);
				String parameterName = parameter.getAttribute(ATTRIBUTE_PARAMETER_NAME);
				String parameterValue = parameter.getTextContent();
				Element inputElement = parent.createElement(INPUT_ELEMENT_NAME);
				inputElement.setAttribute(INPUT_TYPE_NAME, INPUT_TYPE_HIDDEN_VALUE);
				inputElement.setAttribute(INPUT_NAME_NAME, parameterName);
				inputElement.setAttribute(INPUT_VALUE_NAME, parameterValue);
				r.insertBefore(inputElement, parameter);
				r.removeChild(parameter);
			}
		}
		return result;
	}



	@Override
	protected boolean shouldCopy(Attr attribute) {
		return super.shouldCopy(attribute) && !attribute.getName().equals( ATTRIBUTE_ACTION );
	}



	@Override
	protected boolean shouldCopy(Node childNode) {
		return !childNode.getNodeName().equals( PARAMETER_ELEMENT_NAME );
	}

	
}
