package com.ouroboroswiki.core.content.markup.processor;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpression;


public class MarkupAssociation {
	private MarkupHandler handler;
	private XPathExpression xpathExpression;
	private XPath xpath;
	private String path;
	
	public MarkupAssociation( MarkupHandler handler, XPath xpath, String path) 
		throws XPathException {
		this.handler = handler;
//		this.xpath = xpath;
//		this.path = path;
		this.xpathExpression = xpath.compile(path);
	}
	
	public MarkupAssociation( MarkupHandler handler, XPathExpression xpathExpression ) {
		this.handler = handler;
		this.xpathExpression = xpathExpression;
	}
	
	public MarkupHandler getHandler() {
		return this.handler;
	}
	
	public XPathExpression getXPathExpression() {
		return this.xpathExpression;
	}
	
	public XPath getXPath() {
		return this.xpath;
	}
	
	public String getPath() {
		return this.path;
	}
	
	@Override
	public String toString() {
		if( this.path != null ) {
			return this.path;
		} else {
			return this.xpathExpression.toString();
		}
	}
}
