package com.ouroboroswiki.core.content.svg;

import java.util.Map;

import com.ouroboroswiki.core.AbstractContentRepository;
import com.ouroboroswiki.core.Content;
import com.ouroboroswiki.core.ContentException;
import com.ouroboroswiki.core.ContentParameters;
import com.ouroboroswiki.core.ContentPath;
import com.ouroboroswiki.core.ContentRepository;
import com.ouroboroswiki.core.Version;
import com.ouroboroswiki.core.VersionBuilder;

public class SVGToImageContentRepositoryAdapter extends
		AbstractContentRepository {
	
	private ContentRepository svgContentRepository;
	private String mimeType;
	private String informalImageType;
	
	public SVGToImageContentRepositoryAdapter( String mimeType, String informalImageType ) {
		this.mimeType = mimeType;
		this.informalImageType = informalImageType;
	}
	
	public ContentRepository getSvgContentRepository() {
		return svgContentRepository;
	}

	public void setSvgContentRepository(ContentRepository svgContentRepository) {
		this.svgContentRepository = svgContentRepository;
	}

	@Override
	public Version buildVersion(Object principal, ContentPath path,
			String[] versionPath, VersionBuilder versionBuilder)
			throws ContentException {
		return svgContentRepository.buildVersion(principal, path, versionPath, versionBuilder);
	}

	@Override
	public boolean exists(Object principal, ContentPath path)
			throws ContentException {
		return svgContentRepository.exists(principal, path);
	}

	@Override
	public Content getContent(Object principal, ContentPath path,
			Version version, Map<String, Object> properties)
			throws ContentException {
		Content content = svgContentRepository.getContent(principal, path, version, properties);
		// extract the request URL from the properties and use that for an relative links in the SVG
		String uri = (String)properties.get(ContentParameters.PROPERTY_REQUEST_URI);
		return new SVGToImageContentAdapter(content, mimeType, informalImageType, uri);
	}

}
