package com.ouroboroswiki.core.content.svnkit;

import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;

import com.ouroboroswiki.core.ContentException;

public class DefaultSVNKitRepositoryFactory implements SVNKitRepositoryFactory {

	@Override
	public SVNRepository createRepository(
			ISVNAuthenticationManager authenticationManager, 
			SVNURL url)
			throws ContentException {
		try {
			SVNRepository repository = SVNRepositoryFactory.create(url);
			if( authenticationManager != null ) {
				repository.setAuthenticationManager(authenticationManager);
			}
		
			return repository;
		} catch( Exception ex ) {
			throw new ContentException( "unable to create svn repository "+url, ex );
		}
	}

}
