package com.ouroboroswiki.core.content.xml;

import java.util.Map;

import com.ouroboroswiki.core.AbstractContentRepository;
import com.ouroboroswiki.core.Content;
import com.ouroboroswiki.core.ContentException;
import com.ouroboroswiki.core.ContentPath;
import com.ouroboroswiki.core.ContentRepository;
import com.ouroboroswiki.core.Version;
import com.ouroboroswiki.core.VersionBuilder;

public class EscapeXMLContentRepositoryProxy extends AbstractContentRepository {
	
	private ContentRepository proxied;
	private String mimeType;
	
	public EscapeXMLContentRepositoryProxy( ContentRepository proxied, String mimeType ) {
		this.proxied = proxied;
		this.mimeType = mimeType;
	}

	@Override
	public Version buildVersion(Object principal, ContentPath path,
			String[] versionPath, VersionBuilder versionBuilder)
			throws ContentException {
		return proxied.buildVersion(principal, path, versionPath, versionBuilder);
	}

	@Override
	public boolean exists(Object principal, ContentPath path)
			throws ContentException {
		return proxied.exists(principal, path);
	}

	@Override
	public Content getContent(Object principal, ContentPath path, Version version, Map<String, Object> properties)
			throws ContentException {
		Content proxied = this.proxied.getContent(principal, path, version, properties);
		EscapeXMLContentProxy result = new EscapeXMLContentProxy( proxied );
		result.setMimeType( this.mimeType );
		return result;
	}
}
