package com.ouroboroswiki.web;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

import com.ouroboroswiki.core.ContentException;
import com.ouroboroswiki.core.ContentPath;
import com.ouroboroswiki.core.ContentValidationException;

public interface ContentOperation {
	/**
	 * performs an operation upon the content
	 * @param principal the principal being used, can be reassigned if required (set to null to log out)
	 * @param transformations the path to the content
	 * @param parameters operation parameters
	 * @param input any input data
	 * @return the operation result, used in selecting the content source to use to present the output
	 * @throws ContentException if the operation isn't allowed
	 * @throws IOException if there is a problem with reading/writing the operation
	 */
	@SuppressWarnings("unchecked")
	String perform(Object[] principal, ContentPath transformations, Map parameters) throws ContentException, ContentValidationException, IOException;
}
