package com.ouroboroswiki.web;

import java.util.Map;

public class OuroborosServletAction {
	private ContentOperation operation;
	private Map<String, ContentSource> contentSources;
	private ContentSource errorContentSource;
	
	public OuroborosServletAction( Map<String, ContentSource> contentSources ) {
		this( null, contentSources, null );
	}
	
	public OuroborosServletAction( Map<String, ContentSource> contentSources, ContentSource errorContentSource ) {
		this( null, contentSources, errorContentSource );
	}
	
	public OuroborosServletAction( ContentOperation operation, Map<String, ContentSource> contentSources, ContentSource errorContentSource ) {
		this.operation = operation;
		this.contentSources = contentSources;
		this.errorContentSource = errorContentSource;
	}
	
	public ContentOperation getOperation() {
		return operation;
	}
	
	public ContentSource getContentSource( String operationResult ) {
		return contentSources.get(operationResult);
	}
	
	public ContentSource getErrorContentSource() {
		return this.errorContentSource;
	}
	
}
