package br.com.chat.doidao;
//organizao dos pacotes importados
import java.io.IOException;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
//declarao do nome da classe e atributos
public class Servidor {
	private int porta;
	private boolean encerrar;
	private List<PrintStream> clientes;

	//declara o contrutor da classe
	public Servidor (int porta) {
		this.porta = porta;
		this.clientes = new ArrayList<PrintStream>();
	}

	//cria o metodo executa; cria o objeto servidor do tipo ServerSocket; e mostra no console a mensagem de porta aberta 
	public void executa () throws IOException {
		ServerSocket servidor = new ServerSocket(this.porta);
		System.out.println("Porta 12345 aberta!");
// cria um loop de repetio
		while (!encerrar) {
			// aceita um cliente
			Socket cliente = servidor.accept();
			//mostra o endereo do novo cliente conectado.
			System.out.println("Nova conexão com o cliente " +
					cliente.getInetAddress().getHostAddress()
					);

			// adiciona saida do cliente ha lista
			PrintStream ps = new PrintStream(cliente.getOutputStream());
			this.clientes.add(ps);

			// cria tratador de cliente numa nova thread
			TrataCliente tc = new TrataCliente(cliente.getInputStream(), this);
			new Thread(tc).start();
		}

	}

	public void distribuiMensagem(String msg) {
		// envia msg para todo mundo ataves do lao for
		for (PrintStream cliente : this.clientes) {
			cliente.println(msg);
		}
	}
	//finaliza a classe
}