package chat;

import java.awt.Color;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

public class ChatLoginFrame extends JFrame implements KeyListener {
	private static Logger log = Logger.getLogger("chat");
	JTextField jtLogin = new JTextField();
	JButton jbLogin = new JButton();
	JLabel jLabelNick = new JLabel();
	JLabel jLabelLogoMack = new JLabel();
	TitledBorder titledBorder1;
	JLabel jLabel1 = new JLabel();
	JLabel jLabel2 = new JLabel();
	Border border1;
	JLabel jLabel3 = new JLabel();
	JLabel jLabel4 = new JLabel();
	JPanel jPanel1 = new JPanel();
	JLabel jLabel5 = new JLabel();
	private ChatApp chat;

	public ChatLoginFrame() {

	}

	public ChatLoginFrame(ChatApp app) {
		chat = app;
		try {
			jbInit();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private void jbInit() throws Exception {
		this.setTitle("Implementao JXTA chat P2P");
		border1 = BorderFactory.createLineBorder(Color.white, 1);
		jtLogin.setBounds(new Rectangle(5, 184, 171, 21));
		this.getContentPane().setLayout(null);
		jbLogin.setBounds(new Rectangle(244, 182, 95, 23));
		jbLogin.setText("Entrar");
		this.setResizable(false);
		jLabelNick.setText("Digite abaixo o seu nick:");
		jLabelNick.setBounds(new Rectangle(6, 163, 141, 15));
		jLabel1.setFont(new java.awt.Font("SansSerif", 1, 12));
		jLabel1.setText("Implementao JXTA CHAT");
		jLabel1.setBounds(new Rectangle(8, 0, 175, 23));
		jLabel2.setText("Antonio Augusto Mariano Da Silva");
		jLabel2.setBounds(new Rectangle(5, 12, 197, 17));
		jLabel3.setText("Ricardo Augusto Miguel");
		jLabel3.setBounds(new Rectangle(6, 36, 205, 20));
		jLabel4.setText("Ricardo Ribeiro Tavares");
		jLabel4.setBounds(new Rectangle(7, 65, 155, 17));
		jPanel1.setBorder(BorderFactory.createEtchedBorder());
		jPanel1.setLayout(null);
		jPanel1.setBounds(new Rectangle(7, 52, 209, 99));
		jLabel5.setFont(new java.awt.Font("SansSerif", 1, 12));
		jLabel5.setForeground(Color.red);
		jLabel5.setText("Orientador: Prof. Rogrio Oliveira");
		jLabel5.setBounds(new Rectangle(7, 25, 201, 20));
		jPanel1.add(jLabel4, null);
		jPanel1.add(jLabel3, null);
		jPanel1.add(jLabel2, null);
		jtLogin.addKeyListener(this);
		this.getContentPane().add(jtLogin, null);
		this.getContentPane().add(jLabelNick, null);
		this.getContentPane().add(jPanel1, null);
		this.getContentPane().add(jbLogin, null);
		this.getContentPane().add(jLabel5, null);
		this.getContentPane().add(jLabel1, null);
		this.getContentPane().add(jLabelLogoMack, null);
		try {
			MediaTracker tracker = new MediaTracker(this);
			ImageIcon img = new ImageIcon(getClass().getResource("logo.gif"));
			tracker.addImage(img.getImage(), 0);
			tracker.waitForAll();
			jLabelLogoMack.setIcon(img);
			jLabelLogoMack.setBounds(new Rectangle(230, 10,
					img.getIconWidth() + 8, img.getIconHeight() + 8));
		} catch (Exception e) {
			log.warn("Erro ao carregar imagens:" + e.getMessage());
		}
		this.setSize(380, 250);
		this.setDefaultCloseOperation(3);
		jbLogin.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				doLogin();
			}
		});
		show();
	}

	private void hideFrame() {
		this.hide();
	}

	private void doLogin() {
		String nick = jtLogin.getText();
		hideFrame();
		int resultado = chat.loginChat(nick);
		if (resultado < 0) {
			JOptionPane.showMessageDialog(null,	"Ateno, j existe um usurio com este nick no chat, escolha outro!");
			log.fatal("Ateno, j existe um usurio com este nick no chat, escolha outro!");
			System.exit(0);
		}
		jtLogin.setText("");
	}

	public void keyPressed(KeyEvent arg0) {
		if (arg0.getKeyCode() == 10) {
			doLogin();
		}
	}

	public void keyReleased(KeyEvent arg0) {

	}

	public void keyTyped(KeyEvent arg0) {

	}
}
