package chat;

import net.jxta.discovery.DiscoveryService;
import org.apache.log4j.Logger;

/**
 * Esta classe implementa a interface Runnable, e inicia uma thread que procura
 * por novos advertisements na rede a cada 60 segundos.
 */
public class DiscoveryPipes implements Runnable {
	private DiscoveryService discoverySvc;
	/**
	 * Log 'chat' definido em classes/log4j.xml.
	 */
	private static Logger log = Logger.getLogger("chat");

	/**
	 * Construtor da classe que recebe o servio de discovery (DiscoveryService)
	 * da classe chat.ChatApp, e inicia uma nova thread para a procura de
	 * Advertisements.
	 * 
	 * @see chat.ChatApp
	 */
	public DiscoveryPipes(DiscoveryService discoverySvc) {
		this.discoverySvc = discoverySvc;
		Thread t = new Thread(this);
		t.start();
		log.info("Thread para Discovery de pipes criada e iniciada....");
	}

	public void run() {
		while (true) {
			try {
				log.info("Tentando descobrir novos pipes remotamente...");
				discoverySvc.getRemoteAdvertisements(null,
						DiscoveryService.ADV, null, null, 100);
				Thread.sleep(60 * 1000);
			} catch (InterruptedException e) {

			}
		}
	}
}
