//#########################################################################
//        p2pSL-jserver
//
// (C) Copyright by hachreak
//       Released under GPL v2.
//       Author : Hachreak (hachreak at gmail dot com)
//       WebSite: www.secondlifelab.it
//       Date: 29/ott/07 - 18:27:43
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
//#########################################################################

/**
 *  29/ott/07 - 18:27:43
 *  Create by hachreak
 *  Under GPL V2 license
 */

package it.secondlifelab.p2pSL.jserver;

import com.prolixtech.jaminid.Request;
import com.prolixtech.jaminid.Response;

/**
 * @author hachreak
 *
 */
public abstract class AbstractPlugin implements Plugin {

	protected Debug debug;
	protected P2PSLconfig config; 
	
	protected DirectoryLoader dirLoader;
	protected boolean active;
	protected Response connResponse;
	protected Request connRequest; 
	
	/* (non-Javadoc)
	 * @see it.secondlifelab.p2pSL.jserver.Plugin#active(boolean)
	 */
	public void active(boolean active) {
		this.active = active;
	}

	/* (non-Javadoc)
	 * @see it.secondlifelab.p2pSL.jserver.Plugin#getAuthor()
	 */
	public abstract String getAuthor();

	/* (non-Javadoc)
	 * @see it.secondlifelab.p2pSL.jserver.Plugin#getAuthorEmail()
	 */
	public abstract String getAuthorEmail();

	/* (non-Javadoc)
	 * @see it.secondlifelab.p2pSL.jserver.Plugin#getAuthorUrl()
	 */
	public abstract String getAuthorUrl();

	/* (non-Javadoc)
	 * @see it.secondlifelab.p2pSL.jserver.Plugin#getCopyright()
	 */
	public abstract String getCopyright();

	/* (non-Javadoc)
	 * @see it.secondlifelab.p2pSL.jserver.Plugin#getCreationDate()
	 */
	public abstract String getCreationDate();

	/* (non-Javadoc)
	 * @see it.secondlifelab.p2pSL.jserver.Plugin#getDescription()
	 */
	public abstract String getDescription();

	/* (non-Javadoc)
	 * @see it.secondlifelab.p2pSL.jserver.Plugin#getLicense()
	 */
	public abstract String getLicense();

	/* (non-Javadoc)
	 * @see it.secondlifelab.p2pSL.jserver.Plugin#getName()
	 */
	public abstract String getName();

	/* (non-Javadoc)
	 * @see it.secondlifelab.p2pSL.jserver.Plugin#getVersion()
	 */
	public abstract String getVersion();

	/* (non-Javadoc)
	 * @see it.secondlifelab.p2pSL.jserver.Plugin#getVirtualPath()
	 */
	public abstract String getVirtualPath();

	/* (non-Javadoc)
	 * @see it.secondlifelab.p2pSL.jserver.Plugin#isActive()
	 */
	public boolean isActive() {
		return active;
	}

	/* (non-Javadoc)
	 * @see it.secondlifelab.p2pSL.jserver.Plugin#setConfig(it.secondlifelab.p2pSL.jserver.P2PSLconfig)
	 */
	public void setConfig(P2PSLconfig config) {
		this.config = config;
	}

	/* (non-Javadoc)
	 * @see it.secondlifelab.p2pSL.jserver.Plugin#setConnRequest(com.prolixtech.jaminid.Request)
	 */
	public void setConnRequest(Request request) {
		this.connRequest = request;
	}

	/* (non-Javadoc)
	 * @see it.secondlifelab.p2pSL.jserver.Plugin#setConnResponse(com.prolixtech.jaminid.Response)
	 */
	public void setConnResponse(Response response) {
		this.connResponse = response;
	}

	/* (non-Javadoc)
	 * @see it.secondlifelab.p2pSL.jserver.Plugin#setDebug(it.secondlifelab.p2pSL.jserver.Debug)
	 */
	public void setDebug(Debug debug) {
		this.debug = debug;
	}

	/* (non-Javadoc)
	 * @see it.secondlifelab.p2pSL.jserver.Plugin#setDirectoryLoader(it.secondlifelab.p2pSL.jserver.DirectoryLoader)
	 */
	public void setDirectoryLoader(DirectoryLoader dirLoader) {
		this.dirLoader = dirLoader;
	}
	
	/**
	 * Clone the object and inizialize it
	 */
	public Plugin clone(Request request, Response response) throws CloneNotSupportedException{
		Plugin p = (Plugin) this.clone();
		
		//p.setConfig(config);
		p.setConnRequest(request);
		p.setConnResponse(response);
		//p.setDebug(debug);
		//p.setDirectoryLoader(dirLoader);
		
		return p;
	}

}
