//#########################################################################
//        p2pSL-jserver
//
// (C) Copyright by hachreak
//       Released under GPL v2.
//       Author : Hachreak (hachreak at gmail dot com)
//       WebSite: www.secondlifelab.it
//       Date: 24/ott/07 - 17:06:22
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
//#########################################################################

/**
 *  24/ott/07 - 17:06:22
 *  Create by hachreak
 *  Under GPL V2 license
 */

package serverPlugin;

import java.io.IOException;

import com.prolixtech.jaminid.Request;
import com.prolixtech.jaminid.Response;

import it.secondlifelab.p2pSL.jserver.Debug;
import it.secondlifelab.p2pSL.jserver.DirectoryLoader;
import it.secondlifelab.p2pSL.jserver.P2PSLconfig;
import it.secondlifelab.p2pSL.jserver.Plugin;
import it.secondlifelab.p2pSL.jserver.AbstractPlugin;
import it.secondlifelab.p2pSL.jserver.Utility;

/**
 * @author hachreak
 *
 * List of shared files
 */
public class ListPlugin extends AbstractPlugin implements Plugin {

	String name = "List";
	String creationDate = "Oct 2007";
	String author = "Hachreak";
	String copyright = "Hachreak(C). All rights reserved.";
	String authorEmail = "hachreak(at)gmail(dot)comhachreak(at)gmail(dot)com";
	String license = "http://www.gnu.org/copyleft/gpl.html GNU/GPL";
	String authorUrl = "www.secondlifelab.it";
	String version = "1.0";
	String description = "List of file shared";
	String virtualPath = "/list"; 
	
	/* (non-Javadoc)
	 * @see it.secondlifelab.p2pSL.jserver.plugin.Plugin#getAuthor()
	 */
	public String getAuthor() {
		return author;
	}
	/* (non-Javadoc)
	 * @see it.secondlifelab.p2pSL.jserver.plugin.Plugin#getAuthorEmail()
	 */
	public String getAuthorEmail() {
		return authorEmail;
	}
	/* (non-Javadoc)
	 * @see it.secondlifelab.p2pSL.jserver.plugin.Plugin#getAuthorUrl()
	 */
	public String getAuthorUrl() {
		return authorUrl;
	}
	/* (non-Javadoc)
	 * @see it.secondlifelab.p2pSL.jserver.plugin.Plugin#getCopyright()
	 */
	public String getCopyright() {
		return copyright;
	}
	/* (non-Javadoc)
	 * @see it.secondlifelab.p2pSL.jserver.plugin.Plugin#getCreationDate()
	 */
	public String getCreationDate() {
		return creationDate;
	}
	/* (non-Javadoc)
	 * @see it.secondlifelab.p2pSL.jserver.plugin.Plugin#getDescription()
	 */
	public String getDescription() {
		return description;
	}
	/* (non-Javadoc)
	 * @see it.secondlifelab.p2pSL.jserver.plugin.Plugin#getLicense()
	 */
	public String getLicense() {
		return license;
	}
	/* (non-Javadoc)
	 * @see it.secondlifelab.p2pSL.jserver.plugin.Plugin#getName()
	 */
	public String getName() {
		return name;
	}
	/* (non-Javadoc)
	 * @see it.secondlifelab.p2pSL.jserver.plugin.Plugin#getVersion()
	 */
	public String getVersion() {
		return version;
	}
	public String getVirtualPath() {
		return virtualPath;
	}
	
	public String toString(){
		debug.print("Send list");

		String ret = "";

		try {
			ret = Utility.listFile2string(dirLoader.getFiles());
		} catch (IOException e) {			
			debug.print("[ ERROR ] Can't load list of files shared");
			e.printStackTrace();
		}

		return ret;
	}
		
	
	
}
