package br.unisinos.pcds.sgb.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import br.unisinos.pcds.sgb.entity.ItemAcervo;
import br.unisinos.pcds.sgb.action.ItemAcervoForm;
import br.unisinos.pcds.sgb.service.ItemAcervoService;
import java.util.List;

public class ItemAcervoAction extends SGBBaseAction {

	protected Log log = LogFactory.getLog(this.getClass());
	
	@Override
	public ActionForward exec(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		if (SAVE.equalsIgnoreCase(request.getParameter("action"))) {
			return execSave(request);
		} else if (DELETE.equalsIgnoreCase(request.getParameter("action"))) {
			return execDelete(request);
		} else {
			return execFindAll(mapping, request);
		}
	}

	public ActionForward execSave(HttpServletRequest request) {
		// Aqui vai o codigo para salvar
		return null;
	}

	public ActionForward execDelete(HttpServletRequest request) {
		// Aqui vai o codigo para deletar
		return null;
	}

	public ActionForward execFindAll(ActionMapping mapping, HttpServletRequest request) {
		// Aqui vai o codigo para o find
		ItemAcervoService service = new ItemAcervoService();
		try {
			List<ItemAcervo> list = service.findAll();
			ItemAcervoForm form = new ItemAcervoForm();
			form.setItemList(list);
			request.setAttribute("itemAcervoForm", form);
		} catch (Exception e) {
			log.error("execFindAll() Exception: " + e.getMessage(), e);
		}
		return mapping.findForward("listagem");
	}

}
