package br.unisinos.pcds.sgb.dao;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import br.unisinos.pcds.sgb.entity.BaseEntity;

public abstract class BaseDAO<T> extends BaseEntity {

	protected Log log = LogFactory.getLog(this.getClass());

	protected Connection connection;

	private Statement statement;

	protected boolean haveCurrentTransaction = false;

	protected Connection getConnection() throws Exception {

		try {
			Class.forName("com.mysql.jdbc.Driver");
			String url = "jdbc:mysql://localhost:3306/sgb";
			this.connection = DriverManager.getConnection(url, "root", "admin");
		} catch (Exception e) {
			log.error("getConnection() Exception: " + e.getMessage(), e);
			throw e;
		}

		return this.connection;
	}

	public void beginTransaction() throws Exception {
		getConnection();
		this.connection.setAutoCommit(false);
		this.haveCurrentTransaction = true;
	}

	public void commit() throws Exception {
		this.haveCurrentTransaction = false;
		if (!this.connection.getAutoCommit()) {
			this.connection.commit();
		}
		close(this.connection);
	}

	public void rollback() throws Exception {
		this.connection.rollback();
		this.haveCurrentTransaction = false;
		close(this.connection);
	}

	protected Statement getStatement() throws Exception {
		return getConnection().createStatement();
	}

	protected void close(Statement aStatement) throws Exception {
		if (aStatement != null)	aStatement.close();
		close(this.connection);
	}

	protected void close(PreparedStatement aStatement) throws Exception {
		if (aStatement != null) aStatement.close();
		close(this.connection);
	}

	protected void close(PreparedStatement aStatement, ResultSet aResultSet)
			throws Exception {
		if (aStatement != null)
			aStatement.close();
		close(aResultSet);
	}

	protected void close(Statement aStatement, ResultSet aResultSet)
			throws Exception {
		if (aStatement != null)
			aStatement.close();
		close(aResultSet);
	}

	protected void close(ResultSet aResultSet) throws Exception {
		if (aResultSet != null)
			aResultSet.close();
		close(this.connection);
	}

	protected void closeAll() throws Exception {
		if (this.statement != null)
			this.statement.close();
		close(this.connection);
	}

	protected void close(Connection aConnection) throws Exception {
		if (aConnection != null && !aConnection.isClosed()
				&& !this.haveCurrentTransaction) {
			/*
			 * if ( !aConnection.getAutoCommit() ) { aConnection.commit(); }
			 */
			aConnection.close();
		}
	}

	protected List<T> convertToList(ResultSet aResultSet) throws SQLException {
		List<T> result = new ArrayList<T>();
		while (aResultSet.next()) {
			result.add(convertToObject(aResultSet));
		}
		return result;
	}

	protected abstract T convertToObject(ResultSet aResultSet) throws SQLException;

	public abstract T save(T entity);

	public abstract void delete(int id);

	public abstract T findById(int id) throws Exception;

	public abstract List<T> findAll() throws Exception;
}
