package br.unisinos.pcds.sgb.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Date;
import java.util.List;

import br.unisinos.pcds.sgb.entity.ItemAcervo;

public class ItemAcervoDAO extends BaseDAO<ItemAcervo> {

	@Override
	protected ItemAcervo convertToObject(ResultSet aResultSet) throws SQLException {
		// TODO Auto-generated method stub
		ItemAcervo itemAcervo = new ItemAcervo();
		itemAcervo.setId(aResultSet.getInt("ITEM_ACERVO_ID"));
		itemAcervo.setIsbn(aResultSet.getString("ISBN"));
		itemAcervo.setAssunto(aResultSet.getString("ASSUNTO"));
		itemAcervo.setAutores(aResultSet.getString("AUTORES"));
		itemAcervo.setEditora(aResultSet.getString("EDITORA"));
		itemAcervo.setDataEdicao(aResultSet.getDate("DATA_EDICAO"));
		itemAcervo.setEdicao(aResultSet.getInt("EDICAO"));
		itemAcervo.setLocalizacao(aResultSet.getString("LOCALIZACAO"));
		itemAcervo.setNumeroPaginas(aResultSet.getInt("NRO_PAGINAS"));
		itemAcervo.setPavimento(aResultSet.getString("PAVIMENTO"));
		itemAcervo.setTitulo(aResultSet.getString("TITULO"));
		itemAcervo.setVolume(aResultSet.getString("VOLUME"));
		
		return itemAcervo;
	}

	@Override
	public void delete(int id) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public List<ItemAcervo> findAll() throws Exception {
		String sql = "select * " +
					   "from item_acervo ";
		Connection conn = getConnection();
		PreparedStatement prepStat = conn.prepareStatement(sql);
		log.info("Buscando itens de acervo");
		ResultSet rs = prepStat.executeQuery();		
		List<ItemAcervo> list = convertToList(rs);
		if (list.size() > 0) {
			log.info("Registros encontrados");
		} else {
			log.info("Nenhum registro encontrado");
		}
		close(prepStat, rs);
		close(conn);
		return list;
	}

	@Override
	public ItemAcervo findById(int id) throws Exception {
		String sql = "SELECT * " +
					   "FROM itemacervo " + 
					  "WHERE item_acervo_id = ?";
		Connection conn = getConnection();
		PreparedStatement prepStat = conn.prepareStatement(sql);
		prepStat.setInt(1, id);
		log.info("Buscando item de acervo id = " + id);
		ResultSet rs = prepStat.executeQuery();
		rs.last();
		int size = rs.getRow();
		rs.beforeFirst();
		ItemAcervo itemAcervo = new ItemAcervo();
		if (size > 0) {
			itemAcervo = convertToObject(rs);
			log.info("Registro encontrados");
		} else {
			log.info("Nenhum registro encontrado");
		}
		close(prepStat, rs);
		close(conn);
		return itemAcervo;
	}

	@Override
	public ItemAcervo save(ItemAcervo entity) {
		String sql = "INSERT INTO item_acervo( " +
						"isbn," + 
						"titulo," + 
						"assunto," + 
						"autores," + 
						"editora," + 
						"edicao," + 
						"data_edicao," + 
						"nro_paginas," + 
						"volume," + 
						"pavimento," + 
						"localizacao) " +  
		   				" VALUES (" + 
		   				"?," +
		   				"?," +
		   				"?," +
		   				"?," +
		   				"?," +
		   				"?," +
		   				"?," +
		   				"?," +
		   				"?," +
		   				"?," +
		   				"?)";
		try {
			Connection conn = getConnection();
			PreparedStatement prepStat = conn.prepareStatement(sql);
			prepStat.setString(1, entity.getIsbn());
			prepStat.setString(2, entity.getTitulo());
			prepStat.setString(3, entity.getAssunto());
			prepStat.setString(4, entity.getAutores());
			prepStat.setString(5, entity.getEditora());
			prepStat.setInt(6, entity.getEdicao());
			prepStat.setDate(7, (Date) entity.getDataEdicao());
			prepStat.setInt(8, entity.getNumeroPaginas());
			prepStat.setString(9, entity.getVolume());
			prepStat.setString(10, entity.getPavimento());
			prepStat.setString(11, entity.getLocalizacao());
			log.info("Salvando item de acervo ");
			prepStat.executeQuery();
		} catch (Exception e){
			log.error("save Exception: " + e.getMessage(), e);
		}
		return entity;
	}
}
