package br.unisinos.pcds.sgb.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import br.unisinos.pcds.sgb.entity.Perfil;
import br.unisinos.pcds.sgb.entity.Usuario;

public class UsuarioDAO extends BaseDAO<Usuario> {

	@Override
	protected Usuario convertToObject(ResultSet aResultSet) throws SQLException {
		Usuario usuario = new Usuario();
		usuario.setId(aResultSet.getInt("USUARIO_ID"));
		usuario.setNome(aResultSet.getString("NOME"));
		usuario.setLogin(aResultSet.getString("LOGIN"));
		usuario.setSenha(aResultSet.getString("SENHA"));
		usuario.setStatus(aResultSet.getString("STATUS"));
		usuario.setEmail(aResultSet.getString("EMAIL"));
		usuario.setTelefone(aResultSet.getString("TELEFONE"));
		Perfil perfil = Perfil.getInstance(aResultSet.getString("PERFIL"));
		usuario.setPerfil(perfil);
		return usuario;
	}

	@Override
	public void delete(int id) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public List<Usuario> findAll() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Usuario findById(int id) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Usuario save(Usuario entity) {
		// TODO Auto-generated method stub
		return null;
	}

	public Usuario findByLoginAndSenha(String login, String senha) throws Exception {
		if (login == null || "".equals(login.trim())) {
			return null;
		}
		String sql = "select * " +
					 "from   usuario " +
					 "where  login = ? " +
					 "and    senha = md5(?)";
		Connection conn = getConnection();
		PreparedStatement prepStat = conn.prepareStatement(sql);
		prepStat.setString(1, login);
		prepStat.setString(2, senha);
		log.info("Consultando usuario e senha no banco");
		ResultSet rs = prepStat.executeQuery();		
		List<Usuario> list = convertToList(rs);
		Usuario usuario = null;
		if (list.size() > 0) {
			log.info("Usuario e senha bateram");
			usuario = list.get(0);
		} else {
			log.info("Usuario e senha nao bateram");
		}
		close(prepStat, rs);
		close(conn);
		return usuario;
	}
}
