/*
 * Copyright 2009 Zero Separation
 *
 *     This file is part of PDSSQLService.
 *
 *  PDSSQLService is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  PDSSQLService is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with PDSSQLService.  If not, see <http://www.gnu.org/licenses/>.
 *
 */


package com.zero_separation.pds.sql;

import java.io.Serializable;

/**
 * Each SQLConnection represents a logical connection to an SQL server from a PDS
 * cluster.
 *
 * @author Tim Boura - Zero Separation
 */
public interface SQLConnection extends Serializable {

    /**
     * The driver class to use for this connection.
     *
     * @return The name of the connection
     */
    String getDriver();

    /**
     * The JDBC connection string to use for this connection.
     *
     * @return The connection URL
     */
    String getConnectionURL();

    /**
     * Perform the specified query with no notification on success or failure
     * and no result set.
     *
     * Once this method call has completed the SQLStatement object can be modified
     * or deleted without changing the query that will be performed.
     *
     * @param statement The statement to execute
     */
    void performQuery(SQLStatement statement);


    /**
     * Perform the specified statement and then call the specified SQLResultHandler
     * with the results.
     *
     * Once this method call has completed the SQLStatement object can be modified
     * or deleted without changing the query that will be performed.
     *
     * @param statement The statement to execute
     * @param resultHandler The object to call back
     */
    void performQuery(SQLStatement statement, SQLResultHandler resultHandler);

}
