/*
 * Copyright 2009 Zero Separation
 *
 *     This file is part of PDSSQLService.
 *
 *  PDSSQLService is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  PDSSQLService is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with PDSSQLService.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package com.zero_separation.pds.sql;

import com.sun.sgs.app.AppContext;

/**
 *
 * @author Tim
 */
public class SQLConnectionImpl implements SQLConnection {

    /** The version of the serialized form of this class. */
    private static final long serialVersionUID = 1L;

    private String driver;
    private String URL;

    SQLConnectionImpl(String driver, String URL) {
        this.driver = driver;
        this.URL = URL;
    }

    public String getDriver() {
        return driver;
    }

    public String getConnectionURL() {
        return URL;
    }

    public void performQuery(SQLStatement statement) {
        SQLManager sql = AppContext.getManager(SQLManager.class);
        sql.performQuery(this, statement);
    }

    public void performQuery(SQLStatement statement, SQLResultHandler resultHandler) {
        SQLManager sql = AppContext.getManager(SQLManager.class);
        sql.performQuery(this, statement, resultHandler);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final SQLConnectionImpl other = (SQLConnectionImpl) obj;
        if ((this.driver == null) ? (other.driver != null) : !this.driver.equals(other.driver)) {
            return false;
        }
        if ((this.URL == null) ? (other.URL != null) : !this.URL.equals(other.URL)) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 11 * hash + (this.driver != null ? this.driver.hashCode() : 0);
        hash = 11 * hash + (this.URL != null ? this.URL.hashCode() : 0);
        return hash;
    }

}
