/*
 * Copyright 2009 Zero Separation
 *
 *     This file is part of PDSSQLService.
 *
 *  PDSSQLService is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  PDSSQLService is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with PDSSQLService.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package com.zero_separation.pds.sql;

/**
 *
 * @author Tim
 */
public class SQLManagerImpl implements SQLManager {

    private final SQLService backingService;

    public SQLManagerImpl(SQLService service) {
        this.backingService = service;
    }

    public SQLConnection createConnection(String driver, String connectionURL) {
        return backingService.createConnection(driver, connectionURL);
    }

    public void performQuery(SQLConnection connection, SQLStatement statement) {
        performQuery(connection, statement, null);
    }

    public void performQuery(SQLConnection connection, SQLStatement statement, SQLResultHandler resultHandler) {
        backingService.performQuery(connection, statement, resultHandler);
    }

}
