package com.zero_separation.pds.sql;

import java.io.Serializable;

/**
 * Used to store an internal list of the paramaters with each one storing
 * type alongside a POJO. Note that this is an immutable class and if that
 * is changed then the copy constructor in SQLStatement will need updating.
 */
public final class SQLParam implements Serializable {

    private final int type;
    private final Object ob;

    SQLParam(int type, Object ob) {
        super();
        this.type = type;
        this.ob = ob;
    }

    public Object getOb() {
        return ob;
    }

    public int getType() {
        return type;
    }

    @Override
    public String toString() {
        return SQLStatement.getSQLTypeName(type) + ": " + ob;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final SQLParam other = (SQLParam) obj;
        if (this.type != other.type) {
            return false;
        }
        if (this.ob != other.ob && (this.ob == null || !this.ob.equals(other.ob))) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return type + ob.hashCode();
    }
}
