/*
    This file is part of Picasa Album Downloader.

    Picasa Album Downloader is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Picasa Album Downloader is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Picasa Album Downloader.  If not, see <http://www.gnu.org/licenses/>.
*/

import java.util.concurrent.BlockingQueue;

/**
 * 
 * @author Stanislav Ochotnicky <sochotnicky@gmail.com>
 *
 *
 *	Class managing downloading threads
 */
public class ConsumerThread extends Thread {
	private BlockingQueue<WorkerThread> downloadQueue;
	private WorkerThread currentThread;
	public boolean stop;
	
	public ConsumerThread(BlockingQueue<WorkerThread> downloadQueue) {
		this.downloadQueue = downloadQueue;
	}
	
	public void run() {
		stop = false;
		try {
			while(stop != true) {
				currentThread = downloadQueue.take();
				currentThread.run();
			}
			
		} catch(InterruptedException ex) {
			System.err.println(ex);
		}
	}
	
	public WorkerThread getCurrentThread() {
		return currentThread;
	}
}
