package dao;


import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

import modelo.Equipo;
import modelo.Futbolista;

public class EquipoDao {
	
	
//RECUPERAR ID EQUIPO	------------------
//	RECUPERAR IDMAX	------------------
	public static int recuperarIdMax(){
		int id=0;
		Connection conn= null;
		Statement stat= null;
		ResultSet r = null;
		try{
			conn = ConexionBD.getConnection();
			
			stat = conn.createStatement();	
			
			String consulta = "SELECT max(idEquipo) FROM equipo";
			r = stat.executeQuery(consulta);
			r.next();
			id=r.getInt(1);
			System.out.println("Max. id equipo encontrada: "+id);
			return 	id;
							
		} catch(SQLException e){
			System.out.println("Error al Conectar a la BD");
			//e.getStackTrace();
			e.printStackTrace();
			return 0;
			
		}
		finally{
		try{
			if(conn!=null) conn.close();
			if(stat!=null) stat.close();
			if(r!=null) r.close();
		} catch(SQLException e){
			System.out.println("Error al Cerrar la BD");
			e.getStackTrace();
		}
		}
		
}
	
	



	

	//ALTA EQUIPO	------------------
	public static void altaEquipo(Equipo unEquipo){
		Connection conn= null;
		Statement stat= null;
		ResultSet r = null;
		try{
			conn = ConexionBD.getConnection();
			
			stat = conn.createStatement();	
			unEquipo.setPropietario(1);
			System.out.println(unEquipo.getIdE());
			String consulta = "Insert into equipo (NombreEquipo,Prop) values('"+unEquipo.getNombre()+"','"+unEquipo.getPropietario()+"')";
			

			int asd = stat.executeUpdate(consulta);
			if(asd==1) 
				System.out.println("Equipo '"+unEquipo.getNombre()+"' fue a parar a la BD");
						
				
		} catch(SQLException e){
			System.out.println("Error al Conectar a la BD");
			e.printStackTrace();
			
		}
		try{
			if(conn!=null) conn.close();
			if(stat!=null) stat.close();
			if(r!=null) r.close();
		} catch(SQLException e){
			System.out.println("Error al Cerrar la BD");
			e.getStackTrace();
		}	
		
		//int idEquipo = EquipoDao.recuperarIdEquipo(unEquipo);
		
	}
	//ALTA FUTBOLISTA	------------------
	public static void altaFutbolista(int idEquipo, int idFutbolista){
		Connection conn= null;
		Statement stat= null;
		ResultSet r = null;
		try{
			conn = ConexionBD.getConnection();
			
			stat = conn.createStatement();	
			System.out.println("Relacion e-->f "+idEquipo+"\t"+idFutbolista);
			String consulta = "Insert into equipo_futbolista (QueEquipo, QueFutbolista) values('"+
					""+idEquipo+"','"+idFutbolista+"')";
			

			int asd = stat.executeUpdate(consulta);
			if(asd==1) 
				System.out.println("Jugador '"+idFutbolista+"' fue a parar a la BD");
						
				
		} catch(SQLException e){
			System.out.println("Error al Conectar a la BD");
			//e.getStackTrace();
			e.printStackTrace();
			
		}
		try{
			if(conn!=null) conn.close();
			if(stat!=null) stat.close();
			if(r!=null) r.close();
		} catch(SQLException e){
			System.out.println("Error al Cerrar la BD");
			e.getStackTrace();
		}	
	}
	
	//BAJA FUTBOLISTA	------------------
	public static void bajaFutbolista(int idEquipo, int idFutbolista){
		Connection conn= null;
		Statement stat= null;
		ResultSet r = null;
		try{
			conn = ConexionBD.getConnection();
			
			stat = conn.createStatement();	
			//System.out.println("Conn: "+conn+"   Stat: "+stat);
			
			String consulta = "Update equipo_futbolista set juega='0' where" +
					" QueEquipo='"+idEquipo+"' and QueFutbolista='"+idFutbolista+"'";
		
			
			
			int asd = stat.executeUpdate(consulta);
			if(asd==1) 
				System.out.println("Jugador '"+idFutbolista+"' deshabilitado en BD");
						
				
		} catch(SQLException e){
			System.out.println("Error al Conectar a la BD");
			//e.getStackTrace();
			e.printStackTrace();
			
		}
		try{
			if(conn!=null) conn.close();
			if(stat!=null) stat.close();
			if(r!=null) r.close();
		} catch(SQLException e){
			System.out.println("Error al Cerrar la BD");
			e.getStackTrace();
		}	
	}
	
//	BAJA EQUIPO	------------------
	public static void bajaEquipo(int idEquipo){
		Connection conn= null;
		Statement stat= null;
		ResultSet r = null;
		try{
			conn = ConexionBD.getConnection();
			
			stat = conn.createStatement();	
			//System.out.println("Conn: "+conn+"   Stat: "+stat);
			
			String consulta = "Update equipo set Activo='0' where" +
					" idEquipo='"+idEquipo+"'";
		
			
			
			int asd = stat.executeUpdate(consulta);
			if(asd==1) 
				System.out.println("Equipo '"+idEquipo+"' deshabilitado en BD");
						
				
		} catch(SQLException e){
			System.out.println("Error al Conectar a la BD");
			//e.getStackTrace();
			e.printStackTrace();
			
		}
		try{
			if(conn!=null) conn.close();
			if(stat!=null) stat.close();
			if(r!=null) r.close();
		} catch(SQLException e){
			System.out.println("Error al Cerrar la BD");
			e.getStackTrace();
		}	
	}
	
	//MODIFICAR Equipo	------------------
	public static void modificarFutbolista(Futbolista unFutbolista){
		Connection conn= null;
		Statement stat= null;
		ResultSet r = null;
		try{
			conn = ConexionBD.getConnection();
			
			stat = conn.createStatement();	
			//System.out.println("Conn: "+conn+"   Stat: "+stat);
			
			//" set Nombre = "+unFutbolista.getNombre()+
			String consulta = "Update futbolista" +
					" set Edad = '"+unFutbolista.getEdad()+"'"+
					" set Ataja = '"+unFutbolista.getAtajar()+"'"+
					" set Defiende = '"+unFutbolista.getDefender()+"'"+
					" set Ataca = '"+unFutbolista.getAtacar()+"'"+
					" set Inteligencia '"+unFutbolista.getInteligencia()+"'";
			
			
			int asd = stat.executeUpdate(consulta);
			if(asd==1) 
				System.out.println("Jugador '"+unFutbolista.getNombre()+"' Modificado en BD");
						
				
		} catch(SQLException e){
			System.out.println("Error al Conectar a la BD");
			//e.getStackTrace();
			e.printStackTrace();
			
		}
		try{
			if(conn!=null) conn.close();
			if(stat!=null) stat.close();
			if(r!=null) r.close();
		} catch(SQLException e){
			System.out.println("Error al Cerrar la BD");
			e.getStackTrace();
		}	
	}
	//RECUPERAR EQUIPO	------------------
	public static ArrayList<Equipo> recuperarEquipos(){
		Connection conn= null;
		Statement stat= null;
		ResultSet r = null;
		try{
			conn = ConexionBD.getConnection();
			
			stat = conn.createStatement();	
			
			String consulta = "Select * from Equipo";
			r = stat.executeQuery(consulta);
			
			Equipo f= null;
			ArrayList<Equipo> al= new ArrayList<Equipo>();
			while(r.next()){
				f = new Equipo();
				f.setNombre(r.getString("NombreEquipo"));
				f.setIdE(Integer.parseInt(r.getString("idEquipo")));
				f.setPropietario(Integer.parseInt(r.getString("Prop")));
				al.add(f);	
			}
			
			return al;	
			
			
				
						
				
		} catch(SQLException e){
			System.out.println("Error al Conectar a la BD");
			//e.getStackTrace();
			e.printStackTrace();
			return null;
			
		}
		finally{
		try{
			if(conn!=null) conn.close();
			if(stat!=null) stat.close();
			if(r!=null) r.close();
		} catch(SQLException e){
			System.out.println("Error al Cerrar la BD");
			e.getStackTrace();
		}
		}
		
	}


}
