package gui;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.BorderFactory;
import javax.swing.DebugGraphics;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.WindowConstants;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import modelo.Equipo;
import modelo.EquipoCellRender;
import modelo.EquipoListener;
import modelo.FutbolVirtual;
import modelo.FutbolVirtualListener;
import modelo.Futbolista;
import modelo.FutbolistaCellRender;


/**
* This code was edited or generated using CloudGarden's Jigloo
* SWT/Swing GUI Builder, which is free for non-commercial
* use. If Jigloo is being used commercially (ie, by a corporation,
* company or business for any purpose whatever) then you
* should purchase a license for each developer using Jigloo.
* Please visit www.cloudgarden.com for details.
* Use of Jigloo implies acceptance of these licensing terms.
* A COMMERCIAL LICENSE HAS NOT BEEN PURCHASED FOR
* THIS MACHINE, SO JIGLOO OR THIS CODE CANNOT BE USED
* LEGALLY FOR ANY CORPORATE OR COMMERCIAL PURPOSE.
*/
public class AdministracionEquipos extends javax.swing.JFrame implements FutbolVirtualListener,EquipoListener{

	{
		//Set Look & Feel
		try {
			javax.swing.UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel");
		} catch(Exception e) {
			e.printStackTrace();
		}
	}

	private JPanel jPanel1;
	private JLabel jLabel1;
	private JLabel jLabel2;
	private JLabel jLabel3;
	private JLabel jLabel4;
	private JLabel jLabel5;
	private JList futbolistasDeEquipojList1;
	private JList futbolistasjList1;
	private JList equiposjList1;
	private JButton jButton5;
	private JButton jButton2;
	private JButton jButton1;
	private JLabel jLabel6;
	private JTextField jTextField1;
	private JPanel jPanel8;
	private JPanel jPanel7;
	private JPanel jPanel6;
	private JPanel jPanel5;
	private JButton jButton4;
	private JButton jButton3;
	private JPanel jPanel4;
	private JPanel jPanel3;
	
	private static FutbolVirtual modeloFutbolVirtual;
	private JButton jButton7;
	private JButton jButton6;
	private JScrollPane jScrollPane3;
	private JScrollPane jScrollPane2;
	private JLabel inteligenciajLabel;
	private JLabel atacarjLabel;
	private JLabel defenderjLabel;
	private JLabel atajarjLabel;
	private JLabel nombrejLabel;
	
	private static Futbolista futbolistaSelected=null;
	private static Equipo equipoSelected=null;
	private static Futbolista futbolistaDeEquipoSelected=null;


	public AdministracionEquipos(){
		this(new FutbolVirtual(new ArrayList<Futbolista>(),new ArrayList<Equipo>()) );
	}
	
	public AdministracionEquipos(FutbolVirtual modeloFutbolVirtual) {
		super();
		this.modeloFutbolVirtual=modeloFutbolVirtual;
		
		initGUI();
	}
	
	private void initGUI() {
		try {
			setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
			getContentPane().setLayout(null);
			this.setTitle("Virtua Fulbo - Administracion de Equipos");
			this.setAlwaysOnTop(true);
			{
				jPanel1 = new JPanel();
				FlowLayout jPanel1Layout = new FlowLayout();
				getContentPane().add(jPanel1, "Center");
				jPanel1.setBounds(97, 327, 480, 29);
				jPanel1.setLayout(jPanel1Layout);
				{
					jButton7 = new JButton();
					jPanel1.add(jButton7);
					jButton7.setText("Nuevo");
					jButton7.setDebugGraphicsOptions(DebugGraphics.BUFFERED_OPTION);
					jButton7.addActionListener(new ActionListener() {
						public void actionPerformed(ActionEvent evt) {
							jButton7ActionPerformed(evt);
						}
					});
				}
				{
					jButton1 = new JButton();
					jPanel1.add(jButton1);
					jButton1.setText("Guardar");
					jButton1.setBounds(6, 0, 100, 30);
					jButton1.setPreferredSize(new java.awt.Dimension(75, 21));
					jButton1.addActionListener(new ActionListener() {
						public void actionPerformed(ActionEvent evt) {
							jButton1ActionPerformed(evt);
						}
					});
					jButton1.setEnabled(false);
				}
				{
					jButton2 = new JButton();
					jPanel1.add(jButton2);
					jButton2.setText("Eliminar");
					jButton2.setOpaque(true);
					jButton2.setBounds(126, 0, 100, 30);
					jButton2.setEnabled(false);
					jButton2.addActionListener(new ActionListener() {
						public void actionPerformed(ActionEvent evt) {
							jButton2ActionPerformed(evt);
						}
					});
				}
				{
					jButton5 = new JButton();
					jPanel1.add(jButton5);
					jButton5.setText("Finalizar");
					jButton5.setBounds(441, 0, 100, 30);
					jButton5.addActionListener(new ActionListener() {
						public void actionPerformed(ActionEvent evt) {
							jButton5ActionPerformed(evt);
						}
					});
				}
			}
			{
				jPanel3 = new JPanel();
				getContentPane().add(jPanel3);
				jPanel3.setBounds(313, 79, 80, 42);
				{
					jButton3 = new JButton();
					jPanel3.add(jButton3);
					jButton3.setText("<<");
					jButton3.setPreferredSize(new java.awt.Dimension(52, 21));
					jButton3.addActionListener(new ActionListener() {
						public void actionPerformed(ActionEvent evt) {
							jButton3ActionPerformed(evt);
						}
					});
					
					jButton3.setEnabled(false);
				}
			}
			{
				jPanel4 = new JPanel();
				getContentPane().add(jPanel4);
				jPanel4.setBounds(325, 137, 58, 29);
				{
					jButton4 = new JButton();
					jPanel4.add(jButton4);
					jButton4.setText(">>");
					jButton4.setPreferredSize(new java.awt.Dimension(51, 21));
					jButton4.addActionListener(new ActionListener() {
						public void actionPerformed(ActionEvent evt) {
							jButton4ActionPerformed(evt);
						}
					});
					jButton4.setEnabled(false);
				}
			}
			{
				jPanel5 = new JPanel();
				getContentPane().add(jPanel5);
				jPanel5.setBounds(38, 5, 263, 310);
				jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createTitledBorder(""), "Equipos", TitledBorder.LEADING, TitledBorder.TOP));
				jPanel5.setLayout(null);
				{
					jPanel7 = new JPanel();
					jPanel5.add(jPanel7);
					jPanel7.setBounds(25, 109, 210, 185);
					jPanel7.setBorder(BorderFactory.createTitledBorder("Equipo"));
					jPanel7.setLayout(null);
					{
						
						futbolistasDeEquipojList1 = new JList();
						jPanel7.add(futbolistasDeEquipojList1);
						//futbolistasDeEquipojList1.setListData(AdministracionEquipos.equipoSelected.getFutbolistas().toArray());
						futbolistasDeEquipojList1.setCellRenderer(new FutbolistaCellRender());
						futbolistasDeEquipojList1.setBounds(21, 80, 171, 90);
						futbolistasDeEquipojList1.addListSelectionListener(new ListSelectionListener() {
							public void valueChanged(ListSelectionEvent evt) {
								futbolistasDeEquipojList1ValueChanged(evt);
							}
						});
					}
					{
						jTextField1 = new JTextField();
						jPanel7.add(jTextField1);
						jTextField1.setBounds(72, 23, 100, 17);
						jTextField1.setEditable(false);
					}
					{
						jLabel1 = new JLabel();
						jPanel7.add(jLabel1);
						jLabel1.setText("Nombre:");
						jLabel1.setBounds(17, 26, 55, 14);
					}
					{
						jButton6 = new JButton();
						jPanel7.add(jButton6);
						jButton6.setText("Aplicar");
						jButton6.setBounds(82, 46, 78, 20);
						jButton6.setEnabled(false);
					}
				}
				{
					jScrollPane2 = new JScrollPane();
					jPanel5.add(jScrollPane2);
					jScrollPane2.setBounds(30, 21, 205, 85);
					jScrollPane2.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
					jScrollPane2.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
					{
						
						equiposjList1 = new JList();
						jScrollPane2.setViewportView(equiposjList1);
						equiposjList1.setListData(this.modeloFutbolVirtual.getEquipos().toArray());
						equiposjList1.setCellRenderer(new EquipoCellRender());
						equiposjList1.setBounds(25, 23, 210, 86);
						equiposjList1.setPreferredSize(new java.awt.Dimension(153, 12));
						equiposjList1.addListSelectionListener(new ListSelectionListener() {
							public void valueChanged(ListSelectionEvent evt) {
								equiposjList1ValueChanged(evt);
							}
						});
					}
				}
			}
			{
				jPanel6 = new JPanel();
				getContentPane().add(jPanel6);
				jPanel6.setBounds(405, 0, 260, 310);
				jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createTitledBorder(""), "Futbolistas", TitledBorder.LEADING, TitledBorder.TOP));
				jPanel6.setLayout(null);
				{
					jPanel8 = new JPanel();
					jPanel6.add(jPanel8);
					jPanel8.setBounds(21, 156, 212, 131);
					jPanel8.setBorder(BorderFactory.createTitledBorder(BorderFactory.createTitledBorder(""), "Futbolista", TitledBorder.LEADING, TitledBorder.TOP));
					jPanel8.setLayout(null);
					{
						jLabel2 = new JLabel();
						jPanel8.add(jLabel2);
						jLabel2.setText("Nombre:");
						jLabel2.setBounds(17, 24, 59, 14);
					}
					{
						jLabel3 = new JLabel();
						jPanel8.add(jLabel3);
						jLabel3.setText("Atajar:");
						jLabel3.setBounds(17, 44, 59, 14);
					}
					{
						jLabel4 = new JLabel();
						jPanel8.add(jLabel4);
						jLabel4.setText("Defender:");
						jLabel4.setBounds(17, 64, 67, 14);
					}
					{
						jLabel5 = new JLabel();
						jPanel8.add(jLabel5);
						jLabel5.setText("Atacar:");
						jLabel5.setBounds(17, 84, 59, 14);
					}
					{
						jLabel6 = new JLabel();
						jPanel8.add(jLabel6);
						jLabel6.setText("Inteligencia:");
						jLabel6.setBounds(17, 104, 80, 14);
					}
					{
						nombrejLabel = new JLabel();
						jPanel8.add(nombrejLabel);
						nombrejLabel.setBounds(94, 24, 82, 14);
					}
					{
						atajarjLabel = new JLabel();
						jPanel8.add(atajarjLabel);
						atajarjLabel.setBounds(94, 44, 69, 14);
					}
					{
						defenderjLabel = new JLabel();
						jPanel8.add(defenderjLabel);
						defenderjLabel.setBounds(96, 68, 77, 13);
					}
					{
						atacarjLabel = new JLabel();
						jPanel8.add(atacarjLabel);
						atacarjLabel.setBounds(96, 84, 62, 14);
					}
					{
						inteligenciajLabel = new JLabel();
						jPanel8.add(inteligenciajLabel);
						inteligenciajLabel.setBounds(96, 104, 69, 14);
					}
				}
				{
					jScrollPane3 = new JScrollPane();
					jPanel6.add(jScrollPane3);
					jScrollPane3.setBounds(21, 23, 212, 127);
					jScrollPane3.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
					{
						
						futbolistasjList1 = new JList();
						jScrollPane3.setViewportView(futbolistasjList1);
						futbolistasjList1.setListData(this.modeloFutbolVirtual.getFutbolistas().toArray());
						futbolistasjList1.setCellRenderer(new FutbolistaCellRender());
						futbolistasjList1.setBounds(21, 23, 211, 127);
						futbolistasjList1.addListSelectionListener(new ListSelectionListener() {
							public void valueChanged(ListSelectionEvent evt) {
								futbolistasjList1ValueChanged(evt);
							}
						});
					}
				}
			}
			pack();
			this.setSize(700, 400);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void listaDeEquiposModificada(FutbolVirtual futbolVirtual) {
		// TODO Auto-generated method stub
		equiposjList1.setListData(futbolVirtual.getEquipos().toArray());
		
	}

	public void listaDeFutbolistasModificada(FutbolVirtual futbolVirtual) {
		// TODO Auto-generated method stub
		futbolistasjList1.setListData(futbolVirtual.getFutbolistas().toArray());
		
	}
	
	private void futbolistasjList1ValueChanged(ListSelectionEvent evt) {
		System.out.println("futbolistasjList1.valueChanged, event="+evt);
		//TODO add your code for futbolistasjList1.valueChanged
		if(this.futbolistasjList1.getSelectedValue() != null){
			Futbolista f=(Futbolista) this.futbolistasjList1.getSelectedValue();
			nombrejLabel.setText(f.getNombre());
		    atajarjLabel.setText(Integer.toString(f.getAtajar()));
			defenderjLabel.setText(Integer.toString(f.getDefender()));
			atacarjLabel.setText(Integer.toString(f.getAtacar()));
			inteligenciajLabel.setText(Integer.toString(f.getInteligencia()));
			futbolistaSelected=f;
			futbolistasDeEquipojList1.clearSelection();
			
			jButton4.setEnabled(false);
			
			if(equipoSelected!=null)	
				if(equipoSelected.existeFutbolista(futbolistaSelected)||equipoSelected.getFutbolistas().size()>=5){
					jButton3.setEnabled(false);
				} else jButton3.setEnabled(true); 
		}
	}
	
	private void equiposjList1ValueChanged(ListSelectionEvent evt) {
		System.out.println("equiposjList1.valueChanged, event="+evt);
		//TODO add your code for equiposjList1.valueChanged
		if(this.equiposjList1.getSelectedValue()!=null){
			Equipo e=(Equipo) this.equiposjList1.getSelectedValue();
			equipoSelected=e;
			equipoSelected.agregarListener(this);
			if(equipoSelected.getNombre()=="---NUEVO EQUIPO---"){
				jTextField1.setEditable(true);
				jTextField1.setText("NOMBRE");
				equipoSelected.setFutbolistas(new ArrayList<Futbolista>());
			}	
			else{
				jTextField1.setEditable(false);
				jTextField1.setText(equipoSelected.getNombre()); //Nombre Equipo
				jButton2.setEnabled(true); //B Eliminar
			}
			futbolistasDeEquipojList1.setListData(AdministracionEquipos.equipoSelected.getFutbolistas().toArray());
	
		if(futbolistaSelected!=null)	
			if(equipoSelected.existeFutbolista(futbolistaSelected)||equipoSelected.getFutbolistas().size()>=5){
				jButton3.setEnabled(false);
			} else jButton3.setEnabled(true);
		}
	}
	
	private void futbolistasDeEquipojList1ValueChanged(ListSelectionEvent evt) {
		System.out.println("futbolistasDeEquipojList1.valueChanged, event="+evt);
		//TODO add your code for futbolistasDeEquipojList1.valueChanged
		if(this.futbolistasDeEquipojList1.getSelectedValue() != null){
			Futbolista f=(Futbolista) this.futbolistasDeEquipojList1.getSelectedValue();
			nombrejLabel.setText(f.getNombre());	    
			atajarjLabel.setText(Integer.toString(f.getAtajar()));
			defenderjLabel.setText(Integer.toString(f.getDefender()));
			atacarjLabel.setText(Integer.toString(f.getAtacar()));
			inteligenciajLabel.setText(Integer.toString(f.getInteligencia()));
			futbolistaDeEquipoSelected=f;
			
			futbolistasjList1.clearSelection();
			jButton3.setEnabled(false);
			jButton4.setEnabled(true);
			
		}
	}
	//FINALIZAR
	private void jButton5ActionPerformed(ActionEvent evt) {
		System.out.println("jButton5.actionPerformed, event="+evt);
		//TODO add your code for jButton5.actionPerformed
		this.setVisible(false);
		futbolistasjList1.clearSelection();
		equiposjList1.clearSelection();
		
		jTextField1.setText("");
		nombrejLabel.setText(""); atajarjLabel.setText("");
		defenderjLabel.setText(""); atacarjLabel.setText("");
		inteligenciajLabel.setText("");
		futbolistasDeEquipojList1.clearSelection();
		futbolistasDeEquipojList1.setListData(new ArrayList().toArray());
		
		equipoSelected=null;
		futbolistaSelected=null;
		futbolistaDeEquipoSelected=null;
		
		VirtuaFulbo.actualizarListasDeEquipo();
	}
	
	
	//B Agregar Jugador Al Equipo
	private void jButton3ActionPerformed(ActionEvent evt) {
		System.out.println("jButton3.actionPerformed, event="+evt);
		//TODO add your code for jButton3.actionPerformed
		equipoSelected.agregarFutbolista(futbolistaSelected);
		jButton3.setEnabled(false);
		
		if(equipoSelected.getFutbolistas().size()==5&&jTextField1.getText()!="NOMBRE")
			jButton1.setEnabled(true);
	}
	//B Remover Jugador Del Equipo
	private void jButton4ActionPerformed(ActionEvent evt) {
		System.out.println("jButton4.actionPerformed, event="+evt);
		//TODO add your code for jButton4.actionPerformed
		equipoSelected.eliminarFutbolista(futbolistaDeEquipoSelected);
		
		//futbolistasDeEquipojList1.setListData(AdministracionEquipos.equipoSelected.getFutbolistas().toArray());
		jButton4.setEnabled(false);
		jButton1.setEnabled(false);
	}
	//B Guardar
	private void jButton1ActionPerformed(ActionEvent evt) {
		System.out.println("jButton1.actionPerformed, event="+evt);
		//TODO add your code for jButton1.actionPerformed
		Equipo e= new Equipo (jTextField1.getText());
		e.setFutbolistas(equipoSelected.getFutbolistas());
		modeloFutbolVirtual.agregarEquipo(e);
		jButton1.setEnabled(false);
		
	}
	//B Eliminar
	private void jButton2ActionPerformed(ActionEvent evt) {
		System.out.println("jButton2.actionPerformed, event="+evt);
		//TODO add your code for jButton2.actionPerformed
		modeloFutbolVirtual.eliminarEquipo(equipoSelected);
		jButton2.setEnabled(false);
		jTextField1.setText("");
		nombrejLabel.setText(""); atajarjLabel.setText("");
		defenderjLabel.setText(""); atacarjLabel.setText("");
		inteligenciajLabel.setText("");
		futbolistasDeEquipojList1.clearSelection();
		futbolistasDeEquipojList1.setListData(new ArrayList<Futbolista>().toArray());
		equipoSelected=null;
	}

	public void listaDeFutbolistasModificada(Equipo equipo) {
		// TODO Auto-generated method stub
		futbolistasDeEquipojList1.setListData(equipo.getFutbolistas().toArray());
	}
	
	private void jButton7ActionPerformed(ActionEvent evt) {
		System.out.println("jButton7.actionPerformed, event="+evt);
		jTextField1.setEditable(true);
		jTextField1.setText("NOMBRE");
		equipoSelected= new Equipo();
		equipoSelected.setFutbolistas(new ArrayList<Futbolista>());
		futbolistasDeEquipojList1.setListData(equipoSelected.getFutbolistas().toArray());
		//equipoSelected.notificarCambioListaFutbolistas(); 
		equipoSelected.agregarListener(this);
		
		//TODO add your code for jButton7.actionPerformed
	}

}
