package gui;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.WindowConstants;
import javax.swing.border.BevelBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import modelo.Equipo;
import modelo.EquipoCellRender;
import modelo.EquipoListener;
import modelo.FutbolVirtual;
import modelo.FutbolVirtualListener;
import modelo.Futbolista;
import modelo.FutbolistaCellRender;
import modelo.TestVirtuaFulbo;
import dao.ConexionBD;
import dao.EquipoDao;
import dao.FutbolistaDao;

/**
* This code was edited or generated using CloudGarden's Jigloo
* SWT/Swing GUI Builder, which is free for non-commercial
* use. If Jigloo is being used commercially (ie, by a corporation,
* company or business for any purpose whatever) then you
* should purchase a license for each developer using Jigloo.
* Please visit www.cloudgarden.com for details.
* Use of Jigloo implies acceptance of these licensing terms.
* A COMMERCIAL LICENSE HAS NOT BEEN PURCHASED FOR
* THIS MACHINE, SO JIGLOO OR THIS CODE CANNOT BE USED
* LEGALLY FOR ANY CORPORATE OR COMMERCIAL PURPOSE.
*/
public class VirtuaFulbo extends javax.swing.JFrame implements FutbolVirtualListener,EquipoListener {
	private JMenuBar jMenuBar1;
	private JScrollPane jScrollPane1;
	private JScrollPane jScrollPane2;
	private JLabel jLabel3;
	private JLabel jLabel2;
	private JLabel jLabel1;
	private JList futbolistasjList2;
	private JList futbolistasjList1;
	private static JList equipojList2;
	private static JList equipojList1;
	private JButton jButton1;
	private JPanel jPanel4;
	private JPanel jPanel3;
	private JPanel jPanel1;
	private JPanel jPanel2;
	private JMenuItem jMenuItem3;
	private JMenuItem jMenuItem2;
	private JMenuItem jMenuItem1;
	private JMenu jMenu4;
	private JMenu jMenu3;
	private JMenu jMenu2;
	private JMenu jMenu1;
	
	private static AdministracionFutbolistas ventanaFutbolistas=null;
	private static AdministracionEquipos ventanaEquipos=null;
	private static FutbolVirtual modeloFutbolVirtual=null;
	private JPanel jPanel5;
	private JLabel jLabel7;
	private JLabel jLabel6;
	private JLabel jLabel5;

	private static Equipo equipo1Selected=null;
	private static Equipo equipo2Selected=null;
	
	private int conexionBDExitosa=0;
	
	private JLabel jLabel4;

	{
		//Set Look & Feel
		try {
			javax.swing.UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
		} catch(Exception e) {
			e.printStackTrace();
		}
	}


	/**
	* Auto-generated main method to display this JFrame
	*/
	public static void main(String[] args) {
  
	SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				VirtuaFulbo inst = new VirtuaFulbo();
				inst.setLocationRelativeTo(null);
				inst.setVisible(true);
				
				inst.setConexionBDExitosa(inst.conexionInicialBD());
				
				ArrayList<Futbolista> test = null;
				test = FutbolistaDao.recuperarFutbolistas();
				if(test==null){test = new ArrayList<Futbolista>();}
				modeloFutbolVirtual = new FutbolVirtual(FutbolistaDao.recuperarFutbolistas(), EquipoDao.recuperarEquipos());
				modeloFutbolVirtual.agregarListener(inst);
				VirtuaFulbo.actualizarListasDeEquipo();	
			}
		});
	}
	
	public int conexionInicialBD(){
		int conecto=0;
		try{	
			ConexionBD.conectar("jdbc:mysql://localhost:3306/VirtuaFulbo", "root","root");
			System.out.println("Conexion al Servidor OK !");
			conecto=1;
		  }catch (SQLException e){
			        System.out.println("Fallo conexin al Servidor. Fijate que este todo prendido.");
			        conecto=0;
			        
		  } catch (ClassNotFoundException x){
			  System.out.println("\nFalta la libreria 'mysql-connector-java-5.0.5.jar' ");
		  }	 
		  return conecto;
	}
	
	public VirtuaFulbo() {
		super();
		initGUI();	
		this.initAdministracionFutbolistas();
		this.initAdministracionEquipos();
		
	//	public VirtuaFulbo(){}
	}
	
	private void initAdministracionFutbolistas(){
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				//Modelo de prueba para pasar a la ADministracion y probar el JList;
				
				ventanaFutbolistas = new AdministracionFutbolistas(modeloFutbolVirtual);
				modeloFutbolVirtual.agregarListener(ventanaFutbolistas);
				ventanaFutbolistas.setLocationRelativeTo(null);
				ventanaFutbolistas.setVisible(false);
				
			}
		});	
	}
	
	private void initAdministracionEquipos(){
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				ventanaEquipos = new AdministracionEquipos(modeloFutbolVirtual);
				modeloFutbolVirtual.agregarListener(ventanaEquipos);
				ventanaEquipos.setLocationRelativeTo(null);
				ventanaEquipos.setVisible(false);
			}
		});
		
	}
	
	public static void actualizarListasDeEquipo(){
		equipojList1.setListData(modeloFutbolVirtual.getEquipos().toArray());
		equipojList2.setListData(modeloFutbolVirtual.getEquipos().toArray());
	}
	
	private void initGUI() {
		try {
			setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
			getContentPane().setLayout(null);
			this.setPreferredSize(new java.awt.Dimension(640, 480));
			this.setJMenuBar(jMenuBar1);
			this.setMinimumSize(new java.awt.Dimension(640, 480));
			this.setTitle("Virtua Fulbo - Menu Principal");
			{
				jPanel1 = new JPanel();
				FlowLayout jPanel1Layout = new FlowLayout();
				getContentPane().add(jPanel1);
				jPanel1.setLayout(jPanel1Layout);
				jPanel1.setBounds(33, 12, 559, 344);
				jPanel1.setBorder(BorderFactory.createTitledBorder(new SoftBevelBorder(BevelBorder.LOWERED, null, null, null, null), "Partido", TitledBorder.LEADING, TitledBorder.DEFAULT_POSITION));
				{
					jPanel2 = new JPanel();
					jPanel1.add(jPanel2);
					jPanel2.setLayout(null);
					jPanel2.setBounds(35, 39, 187, 303);
					jPanel2.setBorder(BorderFactory.createTitledBorder("Equipo I"));
					jPanel2.setSize(190, 310);
					jPanel2.setPreferredSize(new java.awt.Dimension(190, 310));
					{
						jScrollPane1 = new JScrollPane();
						jPanel2.add(jScrollPane1);
						jScrollPane1.setBounds(13, 22, 161, 95);
						{
							
							equipojList1 = new JList();
							equipojList1.setCellRenderer(new EquipoCellRender());
							jScrollPane1.setViewportView(equipojList1);
							equipojList1.addListSelectionListener(new ListSelectionListener() {
								public void valueChanged(ListSelectionEvent evt) {
									equipojList1ValueChanged(evt);
								}
							});

						}
					}
					{
						
						futbolistasjList1 = new JList();
						jPanel2.add(futbolistasjList1);
						futbolistasjList1.setCellRenderer(new FutbolistaCellRender());
						futbolistasjList1.setBounds(18, 128, 154, 82);
					}
					{
						jLabel1 = new JLabel();
						jPanel2.add(jLabel1);
						jLabel1.setBounds(102, 233, 61, 15);
						jLabel1.setFont(new java.awt.Font("Tahoma",1,12));
					}
					{
						jLabel3 = new JLabel();
						jPanel2.add(jLabel3);
						jLabel3.setBounds(28, 262, 111, 29);
						jLabel3.setFont(new java.awt.Font("Arial Black",1,16));
					}
					{
						jLabel5 = new JLabel();
						jPanel2.add(jLabel5);
						jLabel5.setText("GOLES:");
						jLabel5.setBounds(18, 232, 91, 14);
						jLabel5.setFont(new java.awt.Font("Tahoma",1,12));
					}
				}
				{
					jPanel3 = new JPanel();
					jPanel1.add(jPanel3);
					jPanel3.setLayout(null);
					jPanel3.setBounds(311, 39, 187, 308);
					jPanel3.setBorder(BorderFactory.createTitledBorder("Equipo II"));
					jPanel3.setPreferredSize(new java.awt.Dimension(190, 310));
					jPanel3.setSize(190, 310);
					{
						jScrollPane2 = new JScrollPane();
						jPanel3.add(jScrollPane2);
						jScrollPane2.setBounds(13, 22, 159, 93);
						{
							
							equipojList2 = new JList();
							equipojList2.setCellRenderer(new EquipoCellRender());
							jScrollPane2.setViewportView(equipojList2);
							equipojList2.addListSelectionListener(new ListSelectionListener() {
								public void valueChanged(ListSelectionEvent evt) {
									equipojList2ValueChanged(evt);
								}
							});

						}
					}
					{
						
						futbolistasjList2 = new JList();
						jPanel3.add(futbolistasjList2);
						futbolistasjList2.setCellRenderer(new FutbolistaCellRender());
						futbolistasjList2.setBounds(13, 126, 154, 86);
					}
					{
						jLabel2 = new JLabel();
						jPanel3.add(jLabel2);
						jLabel2.setBounds(85, 232, 62, 14);
						jLabel2.setFont(new java.awt.Font("Tahoma",1,12));
					}
					{
						jLabel4 = new JLabel();
						jPanel3.add(jLabel4);
						jLabel4.setBounds(18, 262, 111, 32);
						jLabel4.setFont(new java.awt.Font("Arial Black",1,16));
					}
					{
						jLabel6 = new JLabel();
						jPanel3.add(jLabel6);
						jLabel6.setText("GOLES:");
						jLabel6.setBounds(13, 232, 85, 14);
						jLabel6.setFont(new java.awt.Font("Tahoma",1,12));
					}
				}
			}
			{
				jPanel4 = new JPanel();
				getContentPane().add(jPanel4);
				jPanel4.setBounds(254, 367, 118, 40);
				{
					jButton1 = new JButton();
					jPanel4.add(jButton1);
					jButton1.setText("Jugar !");
					jButton1.setPreferredSize(new java.awt.Dimension(131, 30));
					jButton1.setFont(new java.awt.Font("Tahoma",1,18));
					jButton1.addActionListener(new ActionListener() {
						public void actionPerformed(ActionEvent evt) {
							jButton1ActionPerformed(evt);
						}
					});
				}
			}
			{
				jPanel5 = new JPanel();
				FlowLayout jPanel5Layout = new FlowLayout();
				getContentPane().add(jPanel5);
				jPanel5.setBounds(10, 370, 229, 51);
				jPanel5.setLayout(jPanel5Layout);
				{
					jLabel7 = new JLabel();
					jPanel5.add(jLabel7);
					jLabel7.setBounds(66, 122, 510, 132);
					jLabel7.setBackground(new java.awt.Color(255,0,0));
					jLabel7.setFont(new java.awt.Font("Tahoma",1,16));
					jLabel7.setPreferredSize(new java.awt.Dimension(231, 32));
				}
			}
			{
				jMenuBar1 = new JMenuBar();
				setJMenuBar(jMenuBar1);
				jMenuBar1.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
				{
					jMenu1 = new JMenu();
					jMenuBar1.add(jMenu1);
					jMenu1.setText("Futbolistas");
					jMenu1.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
					jMenu1.setEnabled(true);
					jMenu1.setOpaque(false);
					{
						jMenuItem1 = new JMenuItem();
						jMenu1.add(jMenuItem1);
						jMenuItem1.setText("Editar Futbolistas");
						jMenuItem1.addActionListener(new ActionListener() {
							public void actionPerformed(ActionEvent evt) {
								jMenuItem1ActionPerformed(evt);
							}
						});
					}
					{
						jMenuItem2 = new JMenuItem();
						jMenu1.add(jMenuItem2);
						jMenuItem2.setText("Salir");
						jMenuItem2.addActionListener(new ActionListener(){
						   public void actionPerformed(ActionEvent e){
							   jMenuItem2ActionPerformed(e);
						   }
						});
						
					}
				}
				{
					jMenu2 = new JMenu();
					jMenuBar1.add(jMenu2);
					jMenu2.setText("Equipos");
					{
						jMenuItem3 = new JMenuItem();
						jMenu2.add(jMenuItem3);
						jMenuItem3.setText("Editar Equipos");
						jMenuItem3.addActionListener(new ActionListener() {
							public void actionPerformed(ActionEvent evt) {
								jMenuItem3ActionPerformed(evt);
							}
						});
					}
				}
				{
					jMenu3 = new JMenu();
					jMenuBar1.add(jMenu3);
					jMenu3.setText("Datos");
					jMenu3.setEnabled(false);
				}
				{
					jMenu4 = new JMenu();
					jMenuBar1.add(jMenu4);
					jMenu4.setText("Ayuda");
					jMenu4.setEnabled(false);
				}
			}
			pack();
			this.setSize(640, 480);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	
	

	private void jMenuItem1ActionPerformed(ActionEvent evt) {
		System.out.println("jMenuItem1.actionPerformed, event="+evt);
		if(this.getConexionBDExitosa()==1)
			ventanaFutbolistas.setVisible(true);
		else jLabel7.setText("Fallo la Conexion a la BD");
	}
	private void jMenuItem2ActionPerformed(ActionEvent e){
		this.dispose();
		System.exit(0);
	}
	private void jMenuItem3ActionPerformed(ActionEvent evt) {
		System.out.println("jMenuItem3.actionPerformed, event="+evt);
		//TODO add your code for jMenuItem3.actionPerformed
		if(this.getConexionBDExitosa()==1)
		ventanaEquipos.setVisible(true);
		else jLabel7.setText("Fallo la Conexion a la BD");
	}

	public void listaDeEquiposModificada(FutbolVirtual futbolVirtual) {
		// TODO Auto-generated method stub
		
	}

	public void listaDeFutbolistasModificada(FutbolVirtual futbolVirtual) {
		// TODO Auto-generated method stub
		
	}

	public void listaDeFutbolistasModificada(Equipo equipo) {
		// TODO Auto-generated method stub
		
	}
	
	private void equipojList1ValueChanged(ListSelectionEvent evt) {
		System.out.println("equipojList1.valueChanged, event="+evt);
		//TODO add your code for equipojList1.valueChanged
		if(this.equipojList1.getSelectedValue()!=null){
			this.limpiarResultados();
			equipo1Selected=(Equipo) this.equipojList1.getSelectedValue();
			futbolistasjList1.setListData(equipo1Selected.getFutbolistas().toArray());
		if(equipo2Selected!=null)
			jButton1.setEnabled(false);
		}
	}
	
	private void equipojList2ValueChanged(ListSelectionEvent evt) {
		System.out.println("equipojList2.valueChanged, event="+evt);
		//TODO add your code for equipojList2.valueChanged
		if(this.equipojList2.getSelectedValue()!=null){
			this.limpiarResultados();
			equipo2Selected=(Equipo) this.equipojList2.getSelectedValue();
			futbolistasjList2.setListData(equipo2Selected.getFutbolistas().toArray());
			if(equipo2Selected!=null)
				jButton1.setEnabled(true);
		}
	}
	
	private void jButton1ActionPerformed(ActionEvent evt) {
		System.out.println("jButton1.actionPerformed, event="+evt);
		//TODO add your code for jButton1.actionPerformed
		int golesE1=modeloFutbolVirtual.cantidadDeGolesDe(equipo1Selected, equipo2Selected);
		int golesE2=modeloFutbolVirtual.cantidadDeGolesDe(equipo2Selected, equipo1Selected);
		jLabel1.setText(Integer.toString(golesE1));
		jLabel2.setText(Integer.toString(golesE2));
		
		if(golesE1>golesE2) jLabel3.setText("GANADOR !");
		if(golesE1<golesE2) jLabel4.setText("GANADOR !");
		if(golesE1==golesE2){
			jLabel4.setText("EMPATE !");
			jLabel3.setText("EMPATE !");
		}

	}
	
	private void limpiarResultados(){
		jLabel1.setText("");
		jLabel2.setText("");
		jLabel3.setText("");
		jLabel4.setText("");
		jButton1.setEnabled(false);
	}

	public int getConexionBDExitosa() {
		return conexionBDExitosa;
	}

	public void setConexionBDExitosa(int conexionBDExitosa) {
		this.conexionBDExitosa = conexionBDExitosa;
	}

}


