package modelo;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

import dao.ConexionBD;
import dao.EquipoDao;
import dao.FutbolistaDao;

public class FutbolVirtual {
	//private static final int MAXJUGADORES = 5;
	private List<Futbolista> futbolistas = new ArrayList<Futbolista>();
	private List<Equipo> equipos = new ArrayList<Equipo>();
	
	private Vector<FutbolVirtualListener> listeners=new Vector<FutbolVirtualListener>();
	
	public FutbolVirtual (List<Futbolista> futbolistas, List<Equipo> equipos){
		this.futbolistas=futbolistas;
		this.equipos=equipos;
		
	}
	
	
	public int cantidadDeGolesDe(Equipo equipoAtacante, Equipo equipoDefensor){
		return (equipoAtacante.coeficienteSituacionesDeGol()/equipoDefensor.coeficienteAnulacionSituacionesDeGol());
	}
	
	public void agregarListener(FutbolVirtualListener listener){
		listeners.add(listener);
	}
	
	public void eliminarListener(FutbolVirtualListener listener){}
	
	public void notificarCambioListaFutbolistas(){
		for (FutbolVirtualListener listener : this.listeners) {
		listener.listaDeFutbolistasModificada(this);
		}
	}
	
	private void notificarCambioListaEquipos(){
		for (FutbolVirtualListener listener : this.listeners) {
		listener.listaDeEquiposModificada(this);
		}
	}
	
	public void agregarEquipo (Equipo e){
		e.setIdE(EquipoDao.recuperarIdMax()+1);
		System.out.println(e.getIdE());
		EquipoDao.altaEquipo(e);
		
		
		if(!this.getEquipos().contains(e)){
			this.getEquipos().add(e);
			this.notificarCambioListaEquipos();
		}
		
	}
	
	public void eliminarEquipo (Equipo unEquipo){
		ListIterator<Equipo> i = equipos.listIterator();
		while(i.hasNext()){
			if(i.next().getNombre()==unEquipo.getNombre()){
				i.remove();
				EquipoDao.bajaEquipo(unEquipo.getIdE());
			this.notificarCambioListaEquipos();
		}
		}
	}
	
	
	
	
	public ArrayList<Futbolista> getFutbolistas() {
		return (ArrayList<Futbolista>) futbolistas;
	}


	public void setFutbolistas(List<Futbolista> futbolistas) {
		this.futbolistas = futbolistas;
	}


	public List<Equipo> getEquipos() {
		return equipos;
	}


	public void setEquipos(List<Equipo> equipos) {
		this.equipos = equipos;
	}

	public boolean existeFutbolista(Futbolista f){
		return this.getFutbolistas().contains(f);
	}

	public void agregarFutbolista (Futbolista f){
		FutbolistaDao.altaFutbolista(f);
		f.setIdF(FutbolistaDao.recuperarIdMax()); 
		
		if(!this.getFutbolistas().contains(f)){
			this.getFutbolistas().add(f);
			this.notificarCambioListaFutbolistas();
		}
		
	}
	
	public void eliminarFutbolista (Futbolista unFutbolista){
		ListIterator<Futbolista> i = futbolistas.listIterator();
		while(i.hasNext()){
			if(i.next().getNombre()==unFutbolista.getNombre())
				i.remove();
			this.notificarCambioListaFutbolistas();
			FutbolistaDao.bajaFutbolista(unFutbolista.getIdF());
			 
		}
		
	}
	
	public void modificarFutbolista (Futbolista unFutbolista){
		ListIterator<Futbolista> i = futbolistas.listIterator();
		while(i.hasNext()){
		if(i.next().getIdF()==unFutbolista.getIdF()){
			i.remove();
			i.add(unFutbolista);
			this.notificarCambioListaFutbolistas();
			FutbolistaDao.modificarFutbolista(unFutbolista);
		}
	}

	}
}
