package model;
import java.awt.BorderLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import javax.swing.WindowConstants;
import javax.swing.SwingUtilities;
import javax.xml.crypto.Data;

import ticketDao.ClienteDao;
import ticketDao.EspectaculoDao;


/**
* This code was edited or generated using CloudGarden's Jigloo
* SWT/Swing GUI Builder, which is free for non-commercial
* use. If Jigloo is being used commercially (ie, by a corporation,
* company or business for any purpose whatever) then you
* should purchase a license for each developer using Jigloo.
* Please visit www.cloudgarden.com for details.
* Use of Jigloo implies acceptance of these licensing terms.
* A COMMERCIAL LICENSE HAS NOT BEEN PURCHASED FOR
* THIS MACHINE, SO JIGLOO OR THIS CODE CANNOT BE USED
* LEGALLY FOR ANY CORPORATE OR COMMERCIAL PURPOSE.
*/
public class PanelEspectaculo extends javax.swing.JFrame {
	private JPanel jPanel1;
	private JLabel jLabel3;
	private JLabel jLabel4;
	private JLabel jLabel5;
	private JButton cBoton;
	private JComboBox cRegistrado;
	private JButton jBorrar;
	private JButton jModificar;
	private JButton jAgregar;
	private JButton jNuevo;
	private JTextField tFecha;
	private JTextField tNombreArtista;
	private JTextField tNombreEspectaculo;
	private JLabel jLabel2;
	private JLabel jLabel1;
	private Principal principal;
	private EspectaculoDao espectaculoDao = null;
	
	/**
	* Auto-generated main method to display this JFrame
	*/
	public static void main(String[] args) {
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				PanelEspectaculo inst = new PanelEspectaculo();
				inst.setLocationRelativeTo(null);
				inst.setVisible(true);
			}
		});
	}
	
	public PanelEspectaculo() {
		super();
		initGUI();
	}
	
	private void initGUI() {
		try {
			setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
			this.setTitle("Administracion de Espectaculos");
			this.setResizable(false);
			{
				jPanel1 = new JPanel();
				getContentPane().add(jPanel1, BorderLayout.CENTER);
				jPanel1.setLayout(null);
				espectaculoDao = new EspectaculoDao();
				jPanel1.setPreferredSize(new java.awt.Dimension(565, 358));
				{
					jLabel1 = new JLabel();
					jPanel1.add(jLabel1);
					jLabel1.setText("Administracion de espectaculos");
					jLabel1.setFont(new java.awt.Font("Arial",3,16));
					jLabel1.setBounds(124, 12, 239, 19);
				}
				{
					jLabel2 = new JLabel();
					jPanel1.add(jLabel2);
					jLabel2.setText("Nombre de espectaculo");
					jLabel2.setBounds(12, 49, 119, 14);
				}
				{
					tNombreEspectaculo = new JTextField();
					jPanel1.add(tNombreEspectaculo);
					tNombreEspectaculo.setBounds(154, 46, 126, 21);
				}
				{
					jLabel3 = new JLabel();
					jPanel1.add(jLabel3);
					jLabel3.setText("Nombre del artista principal");
					jLabel3.setBounds(12, 85, 130, 14);
				}
				{
					tNombreArtista = new JTextField();
					jPanel1.add(tNombreArtista);
					tNombreArtista.setBounds(154, 82, 126, 21);
				}
				{
					jLabel4 = new JLabel();
					jPanel1.add(jLabel4);
					jLabel4.setText("Fecha de realizacion");
					jLabel4.setBounds(12, 125, 97, 14);
				}
				{
					tFecha = new JTextField();
					jPanel1.add(tFecha);
					tFecha.setBounds(154, 122, 126, 21);
				}
				{
					jNuevo = new JButton();
					jPanel1.add(jNuevo);
					jNuevo.setText("Nuevo");
					jNuevo.setBounds(379, 42, 108, 21);
					jNuevo.setSize(113, 21);
				}
				{
					jAgregar = new JButton();
					jPanel1.add(jAgregar);
					jAgregar.setText("Agregar espectaculo");
					jAgregar.setBounds(379, 74, 113, 21);
					jAgregar.addMouseListener(new MouseAdapter() {
						public void mouseClicked(MouseEvent evt) {
							jAgregarMouseClicked(evt);
						}
					});
				}
				{
					jModificar = new JButton();
					jPanel1.add(jModificar);
					jModificar.setText("Modificar");
					jModificar.setBounds(379, 106, 113, 21);
					jModificar.addMouseListener(new MouseAdapter() {
						public void mouseClicked(MouseEvent evt) {
							try {
								jModificarMouseClicked(evt);
							} catch (SQLException e) {
								// TODO Auto-generated catch block
								e.printStackTrace();
							} catch (ClassNotFoundException e) {
								// TODO Auto-generated catch block
								e.printStackTrace();
							}
						}
					});
				}
				{
					jBorrar = new JButton();
					jPanel1.add(jBorrar);
					jBorrar.setText("Borrar espectaculo");
					jBorrar.setBounds(379, 138, 113, 21);
					jBorrar.addMouseListener(new MouseAdapter() {
						public void mouseClicked(MouseEvent evt) {
							try {
								jBorrarMouseClicked(evt);
							} catch (SQLException e) {
								// TODO Auto-generated catch block
								e.printStackTrace();
							} catch (ClassNotFoundException e) {
								// TODO Auto-generated catch block
								e.printStackTrace();
							}
						}
					});
				}
				{
					jLabel5 = new JLabel();
					jPanel1.add(jLabel5);
					jLabel5.setText("Espectaculos registrado");
					jLabel5.setBounds(84, 197, 128, 14);
				}
				{
					String[] listaEspectaculo = generarLista (espectaculoDao.getEspectaculo());
					ComboBoxModel cRegistradoModel = 
						new DefaultComboBoxModel(
								listaEspectaculo);
					cRegistrado = new JComboBox();
					jPanel1.add(cRegistrado);
					cRegistrado.setModel(cRegistradoModel);
					cRegistrado.setBounds(241, 194, 130, 21);
					cRegistrado.addItemListener(new ItemListener() {
						public void itemStateChanged(ItemEvent evt) {
							try {
								cRegistradoItemStateChanged(evt);
							} catch (SQLException e) {
								// TODO Auto-generated catch block
								e.printStackTrace();
							} catch (ClassNotFoundException e) {
								// TODO Auto-generated catch block
								e.printStackTrace();
							}
						}
					});
					cRegistrado.addMouseListener(new MouseAdapter() {
						public void mouseClicked(MouseEvent evt) {
							cRegistradoMouseClicked(evt);
						}
					});
				}
				{
					cBoton = new JButton();
					jPanel1.add(cBoton);
					cBoton.setText("Volver");
					cBoton.setBounds(221, 245, 77, 21);
					cBoton.addMouseListener(new MouseAdapter() {
						public void mouseClicked(MouseEvent evt) {
							cBotonMouseClicked(evt);
						}
					});
				}
			}
			pack();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	private String[] generarLista(ArrayList<Espectaculo> espectaculo) {
		String [] lista = new String [espectaculo.size()];
		int i = 0;
		for (Espectaculo e: espectaculo) {
			lista[i] = e.getNombre();
			i++;
		}
		return lista;
	}

	
	
	
	private void cBotonMouseClicked(MouseEvent evt) {
		principal.setVisible(true);
		this.setVisible(false);
	}

	public void setPrincipal(Principal principal) {
		this.principal = principal;
	}

	public Principal getPrincipal() {
		return principal;
	}
	
	private void jAgregarMouseClicked(MouseEvent evt) {
		
		Espectaculo espectaculo = new Espectaculo();
		espectaculo.setNombre(tNombreEspectaculo.getText());
		espectaculo.setNombreArtista(tNombreArtista.getText());
		espectaculo.setFechaDeRealizacion(new Date(tFecha.getText()));
		
		
		try {
			EmpresaDeEspectaculos.getInstance().agregarEspectaculo(espectaculo);
			String[] listaEspectaculo = generarLista (espectaculoDao.getEspectaculo());
			ComboBoxModel cEspectaculoModel = 
				new DefaultComboBoxModel(
						listaEspectaculo);
			cRegistrado.setModel(cEspectaculoModel);
			
			
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		
		
	}
	
	private void jModificarMouseClicked(MouseEvent evt) throws SQLException, ClassNotFoundException {
		int selected = cRegistrado.getSelectedIndex();
		ArrayList<Espectaculo> espectaculos =espectaculoDao.getEspectaculo();
		Espectaculo espectaculo = espectaculos.get(selected);
		espectaculo.setNombre(tNombreEspectaculo.getText());
		espectaculo.setNombreArtista(tNombreArtista.getText());
		Date date = new Date(tFecha.getText());
		espectaculo.setFechaDeRealizacion(date);
		try {
			EmpresaDeEspectaculos.getInstance().modificarEspectaculo(espectaculo);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	
	
	}
	
	private void jBorrarMouseClicked(MouseEvent evt) throws SQLException, ClassNotFoundException {
		int selected = cRegistrado.getSelectedIndex();
		EspectaculoDao eDao = new EspectaculoDao();
		ArrayList<Espectaculo> espectaculos =eDao.getEspectaculo();
		Espectaculo espectaculo = espectaculos.get(selected);
		try {
			EmpresaDeEspectaculos.getInstance().eliminarEspectaculo(espectaculo);
			String[] listaEspectaculo = generarLista (espectaculoDao.getEspectaculo());
			ComboBoxModel cEspectaculoModel = 
				new DefaultComboBoxModel(
						listaEspectaculo);
			cRegistrado.setModel(cEspectaculoModel);
			tNombreEspectaculo.setText("");
			tNombreArtista.setText("");
			tFecha.setText("");
		
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	private void cRegistradoMouseClicked(MouseEvent evt) {
		System.out.println("cRegistrado.mouseClicked, event="+evt);
		//TODO add your code for cRegistrado.mouseClicked
	}
	
	private void cRegistradoItemStateChanged(ItemEvent evt) throws SQLException, ClassNotFoundException {
		if (cRegistrado.getItemCount()>0) {
			int selected = cRegistrado.getSelectedIndex();
			EspectaculoDao eDao = new EspectaculoDao();
			ArrayList<Espectaculo> espectaculos =eDao.getEspectaculo();
			Espectaculo espectaculo = espectaculos.get(selected);
			tNombreEspectaculo.setText(espectaculo.getNombre());
			tNombreArtista.setText(espectaculo.getNombreArtista());
			tFecha.setText(espectaculo.getFechaDeRealizacion().toString());

			}
	}

}
