package newpackage;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

/**
 * Aplikacja Autokomis
 * Klasa odpowiedzialna za wy�wietlenie okienka edycji rekordu z bazy klient�w lub aut
 * @author Grzegorz Robak
 */

public class edytor extends JFrame implements ActionListener{

	private JLabel[] etykiety=new JLabel[11];
	private JButton zmien;
	private JButton kasuj;
	private JTextField imie;
	private JTextField nazwisko;
	private JTextField litr;
	private JTextField cena;
	private JTextField silnik;
	private JTextField rok;
	private JComboBox marka;
	private JComboBox owner;
	private JTextField model;
	private JCheckBox abs;
	private JCheckBox wspomaganie;
	private JCheckBox szyby;
	private JCheckBox klima;
	private JTextField telefon;
	private JTextField pesel;
	private JTextField adres;
	private MetaDatabase db;
	private Vector<Object> rekordy;
	private int id;
		
	/**
	 * Konstruktor panelu edycji rekordu
	 * @param id identyfikator edytowanego rekordu
	 * @param opcja kt�ry typ rekordu b�dzie edytowany, je�li PRAWDA to klient, w przeciwnym wypadku edycja auta
	 */
	public edytor(int id,boolean opcja) {
		 
		this.id=id;
		setResizable(false);
		setTitle("Edycja");
		setLocationRelativeTo(null);
		if(opcja)	//jesli opcja==true, przygotowujemy panel do obs�ugi wpisu klienta
		{
			setSize(350,180);
			rekordy=MetaDatabase.wlasciciel(id);
			zmien=new JButton("Zmień Dane.");
			kasuj=new JButton("Kasuj Klienta.");
			imie=new JTextField(rekordy.elementAt(1).toString());	
			nazwisko=new JTextField(rekordy.elementAt(2).toString());
			telefon=new JTextField(rekordy.elementAt(3).toString());
			adres=new JTextField(rekordy.elementAt(4).toString());			
			pesel=new JTextField(rekordy.elementAt(5).toString());
			etykiety[0]=new JLabel("Imię");
			etykiety[1]=new JLabel("Nazwisko");
			etykiety[2]=new JLabel("Telefon");
			etykiety[3]=new JLabel("Adres");
			etykiety[4]=new JLabel("Pesel");
			zmien.addActionListener(this);
			kasuj.addActionListener(this);
			setLayout(new GridLayout(6,2));
			this.add(etykiety[0]);
			this.add(imie);
			this.add(etykiety[1]);
			this.add(nazwisko);
			this.add(etykiety[2]);
			this.add(telefon);
			this.add(etykiety[3]);
			this.add(adres);
			this.add(etykiety[4]);
			this.add(pesel);
			this.add(zmien);
			this.add(kasuj);
		}
		if(!opcja){		//jesli opcja==false, przygotowujemy panel do obs�ugi wpisu auta
			setSize(350,250);
			rekordy=MetaDatabase.auto(id);
			zmien=new JButton("Zmień Auto.");
			kasuj=new JButton("Kasuj Auto.");
			setLayout(new GridLayout(10, 2));
			etykiety[2] = new JLabel("Marka");
			etykiety[3] = new JLabel("Rok");
			etykiety[4] = new JLabel("Napęd");
			etykiety[5] = new JLabel("Przebieg [km]");
			etykiety[6] = new JLabel("Model");
			etykiety[7] = new JLabel("Litraż [cm3]");
			etykiety[8] = new JLabel("Cena [PLN]");
			etykiety[9] = new JLabel("Właściciel");
			etykiety[10] = new JLabel("Silnik");
			abs = new JCheckBox("ABS");
			if(rekordy.elementAt(8).toString()=="true")		//ustawienie checkbox'�w na podstawie wpisu w bazie danych
				abs.setSelected(true);
			silnik = new JTextField(rekordy.elementAt(7).toString());//wyci�gniecie z bazy danych odpowiednich danych
			cena = new JTextField(rekordy.elementAt(6).toString());
			litr = new JTextField(rekordy.elementAt(5).toString());
			klima = new JCheckBox("Klimatyzacja");
			if(rekordy.elementAt(11).toString()=="true")
				klima.setSelected(true);
			wspomaganie = new JCheckBox("Wspomaganie kierownicy");
			if(rekordy.elementAt(9).toString()=="true")
				wspomaganie.setSelected(true);
			szyby = new JCheckBox("El. szyby");
			if(rekordy.elementAt(10).toString()=="true")
				szyby.setSelected(true);
			marka = new JComboBox(auta.marki);
			int i;
			for(i=0;i<auta.marki.length;i++)
			{
				if(rekordy.elementAt(2).equals((Object)auta.marki[i]))//przeiterowanie przez tablice marek aut, w poszukiwaniu auta pasuj�cego do wpisu
					break;
			}
			marka.setSelectedIndex(i);//i ustawienie odpowiednie indexu
			owner = new JComboBox(MetaDatabase.nazwiska());
			Vector [] tmp=MetaDatabase.nazwiska();
			for(i=0;i<tmp.length;i++)
			{
				if(rekordy.elementAt(0).equals((Object)id))//podobnie jak wy�ej, lecz szukamy odpowiedniego w�a�ciciela
					break;
			}
			
			owner.setSelectedIndex(i);//i ustawienie odpowiednie indexu
			rok = new JTextField(rekordy.elementAt(4).toString());
			model = new JTextField(rekordy.elementAt(3).toString());
			this.add(etykiety[2]);
			this.add(marka);
			this.add(etykiety[6]);
			this.add(model);
			this.add(etykiety[3]);
			this.add(rok);
			this.add(etykiety[7]);
			this.add(litr);
			this.add(etykiety[10]);
			this.add(silnik);
			this.add(etykiety[8]);
			this.add(cena);
			this.add(etykiety[9]);
			this.add(owner);
			this.add(abs);
			this.add(wspomaganie);
			this.add(szyby);
			this.add(klima);
			zmien.addActionListener(this);
			this.add(zmien);
			kasuj.addActionListener(this);
			this.add(kasuj);
		}
			
		setVisible(true);
	}
	/**
	 * S�uchacz akcji, z wyodr�bnionymi operacjami wybieranymi przy pomocy metody getActionCommand() klasy ActionEvent
	 */
	public void actionPerformed(ActionEvent ae) {
		
		int n=-1;
		Object[] options = {"Tak",//opcje okna dialogowego
        "Nie!"};
		
		if(ae.getActionCommand()=="Zmień Dane."){
			String a,b,c;
			a= imie.getText();
			b= nazwisko.getText();
			c= adres.getText();
		if(a.length()>0)//sprawdzenie danych
			if(b.length()>0)
				if(komis.sprawdzCzyLiczba(telefon.getText(),9))
					if(c.length()>0)
						if(komis.sprawdzCzyLiczba(pesel.getText(),11)){
							MetaDatabase.UpdateKlient(imie.getText(), nazwisko.getText(), telefon.getText(), adres.getText(), pesel.getText(),id);
							komis.setStatus("Zmieniono klienta: "+a+" "+b,false);
							dispose();}
						else
							komis.setStatus("Błędnie podany numer PESEL, proszę popraw.",true);
					else
						komis.setStatus("Błędnie podany adres, proszę popraw.",true);
				else
					komis.setStatus("Błędnie podane numer telefonu, proszę popraw.",true);
			else
				komis.setStatus("Błędnie podany nazwisko, proszę popraw.",true);
		else
			komis.setStatus("Błędnie podane imię, proszę popraw.",true);
		}
		else
		if(ae.getActionCommand()=="Kasuj Klienta.")
		{			
			n = JOptionPane.showOptionDialog(null,
					"Czy jesteś pewien?",
					"Potwierdzenie.",
					JOptionPane.YES_NO_OPTION,
					JOptionPane.QUESTION_MESSAGE,
					null,     //do not use a custom Icon
					options,  //the titles of buttons
					options[0]); //default button title
			if(n == JOptionPane.YES_OPTION)
				{
				MetaDatabase.Kasuj(id,true);
				komis.setStatus("Skasowano klienta", false);
				dispose();
				}
			if(n == JOptionPane.NO_OPTION)
				{
				dispose();
				}					
			}
		if(ae.getActionCommand()=="Zmień Auto."){
			if(komis.sprawdzCzyLiczba(cena.getText())&&komis.sprawdzCzyLiczba(litr.getText(),4)&&komis.sprawdzCzyLiczba(rok.getText(),4)){
			int tmp = Integer.parseInt(MetaDatabase.Tablica(null,null,true)[owner.getSelectedIndex()].elementAt(0).toString());
			MetaDatabase.UpdateAuto(tmp, marka.getSelectedItem().toString(), model.getText(),
					Integer.parseInt(rok.getText()), Integer.parseInt(litr.getText()), 
					Integer.parseInt(cena.getText()), silnik.getText(), abs.isSelected(),
					wspomaganie.isSelected(),szyby.isSelected(), klima.isSelected(),id);
			komis.setStatus("Zmieniono auto", false);
			dispose();
		}
			else{
				komis.setStatus("Błędne dane, proszę popraw.",true);
		}
			}
		else
		if(ae.getActionCommand()=="Kasuj Auto.")
		{
			
			n = JOptionPane.showOptionDialog(null,
					"Czy jesteś pewien?",
					"Potwierdzenie.",
					JOptionPane.YES_NO_OPTION,
					JOptionPane.QUESTION_MESSAGE,
					null,     
					options,  
					options[0]);
			if(n == JOptionPane.YES_OPTION)
				{
				MetaDatabase.Kasuj(id,false);
				komis.setStatus("Skasowano auto", false);
				dispose();
				}
			if(n == JOptionPane.NO_OPTION)
				{
				dispose();
				}
		}
		
				
		}
			
	}

