package newpackage;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;

import javax.swing.*;

/**
 * Aplikacja Autokomis
 * Klasa pe�ni�ca funkcj� g��wnego okna programu
 * @author Grzegorz Robak
 */

public class komis extends JFrame {
 // komponent s�u��cy wy�wietlaniu JPaneli na zak�adkach 
	private JTabbedPane tabbedPane = new JTabbedPane();
//statyczny JLabel, aby m�c si� odwo�a� do niego z poprzez nazw� klasy.
	private static JLabel status=new JLabel("Status");
	/**
	 * przygotowuje rozmiar i wszystkie komponenty, tworzy okno
	 */
	public komis() {
		this.setPreferredSize(new Dimension(800,600));
		this.setMaximumSize(new Dimension(800,600));
		this.setMinimumSize(new Dimension(800,600));
		this.setResizable(false);
		this.setLocationRelativeTo(null);
		this.setTitle("Autokomis");
		 //anonimowe utworzenie klasy MetaDatabase w celu wywo�ania jej konstruktora
		new MetaDatabase();
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		// Dodanie paneli do tabbedPane
		tabbedPane.addTab("Dodaj auto", new PanelDodaj());
		tabbedPane.addTab("Dodaj klienta", new PanelDodajKlient());
		tabbedPane.addTab("Szukaj", new PanelSzukaj());
		tabbedPane.addTab("Konfiguracja", new konfig());
		 //Dodanie tabbedPane do JFrame - Program'u
		this.add(tabbedPane);
		//dodanie JLabel'a służ�cego jako StatusBar
		this.add(status,BorderLayout.SOUTH);
		 //wywo�anie pack(), s�uz�cej do optymalizacji rozmiar�w komponent�w
		this.pack();
		 //uwidocznienie
		setVisible(true);
		komis.setStatus("Witam w bazie danych autokomisu.", false);
		//sprawdzenie czy mo�liwe jest po��czenie do bazy
		if(!MetaDatabase.test())
			//w przeciwnym wypadku przekierowanie do konfiguracji
			tabbedPane.setSelectedIndex(5);
	}
	/**
	 * ustawia tekst w komponencie JLabel
	 * @param stat informacja, kt�ra b�dzie wy�wietlana na Statusie
	 * @param error czy dany komunikat jest b��dem
	 */
	public static void setStatus(String stat,boolean error){
		if(error)
			status.setForeground(Color.red);
		else
			status.setForeground(Color.black);
		status.setText(stat);
		status.repaint();
	}
	/**
	 * sprawdza czy dany String przechowuje liczb�
	 * @param in string sprawdzany czy przechowuje liczb�
	 * @return zwraca czy string przechowuje liczb�(TRUE/FALSE)
	 */
	public static boolean sprawdzCzyLiczba(String in) {
    try {

        Long.parseLong(in);	        
    } catch (NumberFormatException ex) {return false;}	        
    return true; 
	}
	/**
	 * sprawdza czy dany String przechowuje liczb� i posiada odpowiedni� d�ugo��
	 * @param in string sprawdzany czy przechowuje liczb�
	 * @param len dlugosc stringa sprawdzanego
	 * @return zwraca czy string przechowuje liczb�(TRUE/FALSE)
	 */
	public static boolean sprawdzCzyLiczba(String in,int len){
		if(sprawdzCzyLiczba(in) && in.length()==len)
			return true;
		else{
			return false;}
	}
	/**
	 * Metoda main klasy, wywo�ujemy tu kontruktor klasy
	 * @param args
	 */
	public static void main(String args[]) {
		new komis();
		
	}
}