package fachada;

import java.util.ArrayList;

import produto.ControladorProduto;
import produto.Produto;
import produto.ProdutoJaCadastradoException;
import servico.ControladorServico;
import servico.Servico;
import servico.ServicoJaCadastradoException;
import usuario.ControladorUsuario;
import cliente.Cliente;
import cliente.ClienteJaCadastradoException;
import cliente.ControladorCliente;
import fornecedor.ControladorFornecedor;
import fornecedor.Fornecedor;
import funcionario.ControladorFuncionario;
import funcionario.Funcionario;

public class Fachada{
	
	private static Fachada instance = null;
	private ControladorCliente controladorCliente;
	private ControladorFornecedor controladorFornecedor;
	private ControladorFuncionario controladorFuncionario;
	private ControladorProduto controladorProduto;
	private ControladorServico controladorServico;
	private ControladorUsuario controladorUsuario;
	
	public Fachada() throws Exception{
		this.controladorCliente = new ControladorCliente();
		this.controladorFornecedor = new ControladorFornecedor();
		this.controladorFuncionario = new ControladorFuncionario ();
		this.controladorProduto = new ControladorProduto();
		this.controladorServico = new ControladorServico();
		this.controladorUsuario = new ControladorUsuario();
		
	}
	
	public static Fachada getInstance() throws Exception{
		if(Fachada.instance == null){
			Fachada.instance = new Fachada();
		}
		
		return instance;
		
	}
	
	
	///// CLIENTE /////
	
	
	public void ClienteCadastrar(Cliente cliente) throws ClienteJaCadastradoException{
		this.controladorCliente.ClienteCadastrar(cliente);
		
	}
	
	public Cliente ClienteProcurar(String cpf) {
		return this.controladorCliente.ClienteProcurar(cpf);
	}
	
	public void ClienteAtualizar(Cliente cliente){
		this.controladorCliente.ClienteAtualizar(cliente);
	}
	public void ClienteRemover(String cpf){
		this.controladorCliente.ClienteRemover(cpf);
	}
	
	public ArrayList<Cliente> ClienteListar() throws Exception{
		
		return null;
		
	}
	
	
//// FORNECEDOR  /////
	
	
	public void FornecedorCadastrar(Fornecedor fornecedor) {
		this.controladorFornecedor.FornecedorCadastrar(fornecedor);
		
	}

	public void FornecedorRemover(String cnpj) {
		this.controladorFornecedor.FornecedorRemover(cnpj);
		
	}

	public ArrayList<Fornecedor> FornecedorProcurar(String cnpj)  {
		this.controladorFornecedor.FornecedorProcurar(cnpj);
		return null;
	}

	public void FornecedorAtualizar(Fornecedor fornecedor) {
		this.controladorFornecedor.FornecedorAtualizar(fornecedor);		
	}
	
	public ArrayList<Fornecedor> FornecedorListar() {
		
		return null;
	}	
	
	///// FUNCIONRIO /////
	

	public void FuncionarioCadastrar(Funcionario funcionario) {
		this.controladorFuncionario.FuncionarioCadastrar(funcionario);
		
	}

	public Funcionario FuncionarioProcurar(String cpf) {
		return this.controladorFuncionario.FuncionarioProcurar(cpf);
	}

	public void FuncionarioAtualizar(Funcionario funcionario) {
		
		
	}
	public void FuncionarioRemover(String cpf){
		this.controladorFuncionario.FuncionarioRemover(cpf);
	}

	public ArrayList<Funcionario> FuncionarioListar() throws Exception {
		return null;
	}
	
///// PRODUTO /////
	
	
	public void ProdutoCadastrar( Produto produto){
		this.controladorProduto.ProdutoCadastrar(produto);
		
	}
	
	public Produto ProdutoProcurar (String codigo){
		return this.controladorProduto.ProdutoProcurar(codigo);
		
		}
	
	public void ProdutoAtualizar(Produto produto){
	
	}
	public void ProdutoRemover(String codigo){
		this.controladorProduto.ProdutoRemover(codigo);
	}
	
	public ArrayList<Produto> ProdutoListar() throws Exception{
		
		return null;
		
	}
	
	
///// SERVICO /////
	
	
	public void ServicoCadastrar( Servico servico){
		this.controladorServico.ServicoCadastrar(servico);
		
	}
	
	public Servico ServicoProcurar (String codigo){
		return this.controladorServico.ServicoProcurar(codigo);
		
		}
	
	public void ServicoAtualizar(Servico servico){
	
	}
	public void ServicoRemover(String codigo){
		this.controladorServico.ServicoRemover(codigo);
	}
	
	public ArrayList<Servico> ServicoListar() throws Exception{
		
		return null;
		
	}
	
	////Usuario 
	
	public ControladorUsuario getControladorUsuario() {
		return controladorUsuario;
		
		
	}
	
	
	
	
	

}
