package funcionario;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import com.mysql.jdbc.Connection;

import conexao.ConectarComBanco;

public class RepositorioFuncionarioBDR implements IRepositorioFuncionario {

	@Override
	public void FuncionarioCadastrar(Funcionario funcionario) {

		String sql = "INSERT INTO funcionario (nome, cpf, cargo, salario, endereco, telefone, email, sexo) VALUES(?,?,?,?,?,?,?,?)";
		// "INSERT INTO funcionario (idfuncionario, nome, cpf, cargo, salario, endereco, telefone, email, sexo) VALUES (NULL, 'Isa', '7658584', 'Gerente', NULL, 'Rua 19', '8675858584', 'isa.mascena', 'FEMININO');"

		java.sql.PreparedStatement prstm = null;
		Connection conn = null;

		try {

			conn = ConectarComBanco.ConectarComMysql();
			prstm = conn.prepareStatement(sql);
			prstm.setString(1, funcionario.getNome());
			prstm.setString(2, funcionario.getCpf());
			prstm.setString(3, funcionario.getCargo());
			prstm.setString(4, funcionario.getSalario());
			prstm.setString(5, funcionario.getEndereco());
			prstm.setString(6, funcionario.getTelefone());
			prstm.setString(7, funcionario.getEmail());
			prstm.setString(8, funcionario.getSexo());

			prstm.execute();

		} catch (Exception e) {

			e.printStackTrace();

		} finally {

			try {

				if (prstm != null) {
					prstm.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (Exception e) {
				e.printStackTrace();
			}

		}

	}

	@Override
	public void FuncionarioRemover(String cpf) {

		String sql = "DELETE FROM funcionario WHERE cpf = ?; ";

		java.sql.PreparedStatement prstm = null;
		Connection conn = null;

		try {

			conn = ConectarComBanco.ConectarComMysql();
			prstm = conn.clientPrepareStatement(sql);
			prstm.setString(1, cpf);
			prstm.execute();

		} catch (Exception e) {
			// e.printStackTrace();
			System.out.println("ERRO: " + e);

		}

	}

	@Override
	public Funcionario FuncionarioProcurar(String cpf) {
		

		Funcionario funcionario = new Funcionario();

		Connection conn = null;
		java.sql.PreparedStatement prstm = null;
		ResultSet resultSet = null;

		
		String sql = "SELECT * FROM funcionario WHERE cpf='" + cpf + "' LIMIT 1; ";
		System.out.println("SQL: "+sql);
		try {
			conn = ConectarComBanco.ConectarComMysql();
			prstm = conn.prepareStatement(sql);
			resultSet = prstm.executeQuery();
			while (resultSet.next()) {
				
				funcionario.setId(resultSet.getInt("idfuncionario"));
				funcionario.setNome(resultSet.getString("nome"));
				funcionario.setCpf(resultSet.getString("cpf"));
				funcionario.setCargo(resultSet.getString("cargo"));
				funcionario.setSalario(resultSet.getString("salario"));
				funcionario.setEndereco(resultSet.getString("endereco"));
				funcionario.setTelefone(resultSet.getString("telefone"));
				funcionario.setEmail(resultSet.getString("email"));
				funcionario.setSexo(resultSet.getString("sexo"));
				
			}
		} catch (Exception e) {
			System.out.println("ERRO:"+e);

		}
		return funcionario;

	}

	@Override
	public void FuncionarioAtualizar(Funcionario funcionario) {

		String sql = "UPDATE funcionario SET nome = ?, cpf = ?, cargo = ?, salario = ?, endereco = ?, telefone = ?, email = ?, sexo = ? WHERE idfuncionario = ?; ";
		             

		java.sql.PreparedStatement prstm = null;
		Connection conn = null;

		System.out.println("socorrro: "+funcionario.toString());
		
		try {

			conn = ConectarComBanco.ConectarComMysql();
			prstm = conn.prepareStatement(sql);
			prstm.setString(1, funcionario.getNome());
			prstm.setString(2, funcionario.getCpf());
			prstm.setString(3, funcionario.getCargo());
			prstm.setString(4, funcionario.getSalario());
			prstm.setString(5, funcionario.getEndereco());
			prstm.setString(6, funcionario.getTelefone());
			prstm.setString(7, funcionario.getEmail());
			prstm.setString(8, funcionario.getSexo());
			
			prstm.setInt(9, funcionario.getId());

			prstm.execute();
			

		} catch (Exception e) {
			System.out.println("ERRO: "+e);
		} 

	}

	@Override
	public ArrayList<Funcionario> FuncionarioListar() {
		String sql = "SELECT * FROM funcionario";

		Connection conn = null;
		java.sql.PreparedStatement prstm = null;
		ResultSet resultSet = null;

		ArrayList<Funcionario> listaFuncionario = new ArrayList<Funcionario>();

		try {
			conn = ConectarComBanco.ConectarComMysql();
			prstm = conn.prepareStatement(sql);
			resultSet = prstm.executeQuery();

			while (resultSet.next()) {

				Funcionario funcionario = new Funcionario(
						resultSet.getString("nome"),
						resultSet.getString("cpf"),
						resultSet.getString("cargo"),
						resultSet.getString("salario"),
						resultSet.getString("endereco"),
						resultSet.getString("telefone"),
						resultSet.getString("email"),
						resultSet.getString("sexo"));

				listaFuncionario.add(funcionario);
				System.out.println(resultSet.getString("nome") + " "
						+ resultSet.getString("cpf"));

			}

		}

		catch (Exception e) {
			e.printStackTrace();
		}

		return listaFuncionario;
	}

}
