package gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.table.DefaultTableModel;

import servico.RepositorioServicoBDR;
import servico.Servico;
import agenda.Agenda;
import agenda.RepositorioAgendaBDR;
import cliente.Cliente;
import cliente.RepositorioClienteBDR;

import com.toedter.calendar.JDateChooser;

import funcionario.Funcionario;
import funcionario.RepositorioFuncionarioBDR;
 

public class GUIagenda extends JFrame {


	        //variaveis para uso da JTable 
	    JTable tabAgenda;
	    final String colunas[]={"Nome:","Idade:","Sexo:"};
	    final String dados[][]={};
	    JComboBox selFuncionario;
	    JDateChooser txtData;
	    JComboBox selCliente;
	    JComboBox selServico;
	    JComboBox selStatus;
	    JButton btnSalvar;
	    JButton btnExcluir;
	    JButton btnSair;
	    
	    ArrayList<Funcionario> arrayFuncionario = new ArrayList<>();
	    ArrayList<Cliente> arrayCliente = new ArrayList<>();
	    ArrayList<Servico> arrayServico = new ArrayList<>();
	    ArrayList<Agenda> arrayAgendado = new ArrayList<>();
	    
	    
	    private JTextField txtFone;
	    private JComboBox selHorario;
	    
	            
	     
	        /*Construtor da classe ,
	          antes de executar o metodo main(),
	          ir construir o JFrame e a JTable*/
	    public GUIagenda() {
	    	getContentPane().setBackground(UIManager.getColor("CheckBox.background"));
	        setSize(new Dimension(952, 576));//tamanho do Formulario
	        setLocationRelativeTo(null);//centralizado
	        setTitle("Exemplo JTable");//titulo
	        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	                                                               // neste caso  ir fechar o programa
	        
	        atualizaAgenda();
	        
	        JPanel panel = new JPanel();
	        panel.setBackground(new Color(245, 245, 245));
	        panel.setForeground(new Color(128, 128, 128));
	        panel.setBorder(new EtchedBorder(EtchedBorder.LOWERED, new Color(139, 0, 139), null));
	        panel.setBounds(10, 10, 916, 119);
	        getContentPane().add(panel);
	        panel.setLayout(null);
	        
	        selFuncionario = new JComboBox();
	        selFuncionario.setBackground(new Color(255, 255, 255));
	        selFuncionario.setBounds(10, 33, 190, 20);
	        panel.add(selFuncionario);
	        
	        JLabel label = new JLabel("Profissional:");
	        label.setBounds(10, 11, 89, 14);
	        panel.add(label);
	        
	        selServico = new JComboBox();
	        selServico.setBackground(new Color(255, 255, 255));
	        selServico.setBounds(10, 88, 397, 20);
	        panel.add(selServico);
	        
	        JLabel lblNewLabel = new JLabel("Servi\u00E7o:");
	        lblNewLabel.setBounds(10, 64, 114, 14);
	        panel.add(lblNewLabel);
	        
	        txtData = new JDateChooser();
	        txtData.setBounds(210, 33, 89, 20);
	        panel.add(txtData);
	        
	        JLabel lblNewLabel_1 = new JLabel("Data:");
	        lblNewLabel_1.setBounds(210, 11, 38, 14);
	        panel.add(lblNewLabel_1);
	        
	        JLabel lblHorrio = new JLabel("Hor\u00E1rio:");
	        lblHorrio.setBounds(309, 11, 98, 14);
	        panel.add(lblHorrio);
	        
	        JLabel lblNewLabel_2 = new JLabel("Telefone:");
	        lblNewLabel_2.setBounds(436, 11, 69, 14);
	        panel.add(lblNewLabel_2);
	        
	        selStatus = new JComboBox();
	        selStatus.setBackground(new Color(255, 255, 255));
	        selStatus.setBounds(436, 88, 140, 20);
	        panel.add(selStatus);
	        
	        JLabel lblNewLabel_3 = new JLabel("Cliente:");
	        lblNewLabel_3.setBounds(611, 11, 114, 14);
	        panel.add(lblNewLabel_3);
	        
	        selCliente = new JComboBox();
	        selCliente.setBackground(new Color(255, 255, 255));
	        selCliente.setBounds(611, 33, 280, 20);
	        panel.add(selCliente);
	        
	        JLabel lblStatus = new JLabel("Status:");
	        lblStatus.setBounds(436, 64, 46, 14);
	        panel.add(lblStatus);
	        
	        btnSalvar = new JButton("Salvar");
	        btnSalvar.addActionListener(new ActionListener() {
	        	public void actionPerformed(ActionEvent arg0) {
	        		salvarAgenda();
	        	}

				private void salvarAgenda() {


					Agenda agend = new Agenda();
					
				
					agend.setProfissional(String.valueOf(selFuncionario.getSelectedItem()));
					agend.setData(String.valueOf(txtData.getDate()));
					agend.setHora(String.valueOf(selHorario.getSelectedItem()));
					agend.setTelefone(txtFone.getText());
					agend.setCliente(String.valueOf(selCliente.getSelectedItem()));
					agend.setServico(String.valueOf(selServico.getSelectedItem()));
					agend.setStatus(String.valueOf(selStatus.getSelectedItem()));
					
					RepositorioAgendaBDR reposg = new RepositorioAgendaBDR();
					reposg.AgendaCadastrar(agend);
					
					atualizaAgenda();
					
				}
	        });
	        btnSalvar.setBounds(611, 85, 89, 23);
	        panel.add(btnSalvar);
	        
	        btnExcluir = new JButton("Excluir");
	        btnExcluir.addActionListener(new ActionListener() {
	        	public void actionPerformed(ActionEvent arg0) {
	        		
	        		int result = JOptionPane.showConfirmDialog(null, "Deseja realmente excluir o registro ?");
	        		if (result == 0){
	        			excluirAgenda();
	        		}
	        	}

				private void excluirAgenda() {
					
					int linSel = tabAgenda.getSelectedRow();
					System.out.println("eixo: "+linSel);
					
					Agenda agendaExcluir = arrayAgendado.get(linSel);
					
					RepositorioAgendaBDR reposg = new RepositorioAgendaBDR();
					reposg.AgendaRemover(agendaExcluir.getId());
					
					atualizaAgenda();
					
					
				}
	        });
	        btnExcluir.setBounds(707, 85, 89, 23);
	        panel.add(btnExcluir);
	        
	        btnSair = new JButton("Sair");
	        btnSair.addActionListener(new ActionListener() {
	        	public void actionPerformed(ActionEvent arg0) {
	        		dispose();
	        	}
	        });
	        btnSair.setBounds(806, 85, 89, 23);
	        panel.add(btnSair);
	        
	        txtFone = new JTextField();
	        txtFone.setBounds(436, 33, 140, 20);
	        panel.add(txtFone);
	        txtFone.setColumns(10);
	        
	        selHorario = new JComboBox();
	        selHorario.setBackground(new Color(255, 255, 255));
	        selHorario.setBounds(311, 31, 98, 20);
	        panel.add(selHorario);
	        
	        
	        preencherFuncio();
	        
	        preencherCliente();
	        
	        preencherStatus();
	        
	        preencherServico();
	        
	        preencherHorarios();
	    }
	     
	        private void atualizaAgenda() {
	        	RepositorioAgendaBDR repoAgenda = new RepositorioAgendaBDR();
		        
		        this.arrayAgendado = repoAgenda.AgendaListar();
		        
		        int qtdItensAgenda = this.arrayAgendado.size();
		        
			Object[][] valoresDaAgenda = new Object[qtdItensAgenda][7];

			for (int i = 0; i < qtdItensAgenda; i++) {
				
				Agenda agenda = this.arrayAgendado.get(i);
				
				valoresDaAgenda[i][0] = agenda.getData();
				valoresDaAgenda[i][1] = agenda.getHora();
				valoresDaAgenda[i][2] = agenda.getServico();
				valoresDaAgenda[i][3] = agenda.getCliente();
				valoresDaAgenda[i][4] = agenda.getTelefone();
				valoresDaAgenda[i][5] = agenda.getProfissional();
				valoresDaAgenda[i][6] = agenda.getStatus();
			}

		                //instanciando a JTable
		        tabAgenda=new JTable(dados,colunas);
		        tabAgenda.setBorder(new EtchedBorder(EtchedBorder.LOWERED, new Color(153, 51, 153), null));
		        tabAgenda.setFont(new Font("Arial Narrow", Font.PLAIN, 15));
		        tabAgenda.setModel(new DefaultTableModel(
		        	
		        		valoresDaAgenda,
		        	
		        	new String[] {
		        		"Data:", "Hora:", "Servi\u00E7o:", "Cliente:", "Telefone:", "Profissional:", "Status:"
		        	}
		        	
		        ));
		        
		        tabAgenda.getColumnModel().getColumn(0).setPreferredWidth(37);
		        tabAgenda.getColumnModel().getColumn(1).setPreferredWidth(37);
		        tabAgenda.getColumnModel().getColumn(2).setPreferredWidth(96);
		        	        
	         
		                //adicionando a tabela em uma barra de rolagem, ficar envolta , pela mesma 
		        JScrollPane scrollPane=new JScrollPane(tabAgenda);
		        scrollPane.setBounds(10, 140, 916, 336);
		                 
		                //adicionando ao JFrame "Formulrio" a JTable "Tabela" 
		        getContentPane().add(scrollPane);
				
			}

			private void preencherHorarios() {

	        	for (int j = 0; j <= 9; j++) {
	        		selHorario.addItem("0"+j+":00");
				}
	        	for (int i = 10; i <= 23; i++) {
	        		selHorario.addItem(i+":00");
				}
				
			}

			private void preencherServico() {
				
	        	RepositorioServicoBDR repo = new RepositorioServicoBDR();
	        	this.arrayServico.add(null);
	        	selServico.addItem("Escolha o tipo de servio..."
	        			+ "");
	        	this.arrayServico = repo.ServicoListar();
	        	for (Servico serv : this.arrayServico) {
	        		selServico.addItem(serv.getNome());
				}
				
			}

			private void preencherStatus() {
	        	selStatus.addItem("Escolha");
				selStatus.addItem("Agendado");
				selStatus.addItem("Marcado");
				selStatus.addItem("No Confirmado");
				
			}

			private void preencherCliente() {
	        	RepositorioClienteBDR repo = new RepositorioClienteBDR();
	        	this.arrayCliente.add(null);
	        	selCliente.addItem("Escolha o cliente...");
	        	this.arrayCliente = repo.ClienteListar();
	        	for (Cliente clien : this.arrayCliente) {
	        		selCliente.addItem(clien.getNome());
				}
				
			}

			private void preencherFuncio() {
				
	        	RepositorioFuncionarioBDR repo = new RepositorioFuncionarioBDR();
	        	this.arrayFuncionario.add(null);
	        	selFuncionario.addItem("Escolha o profissional...");
	        	this.arrayFuncionario = repo.FuncionarioListar();
	        	for (Funcionario funcio : this.arrayFuncionario) {
	        		selFuncionario.addItem(funcio.getNome());
				}
				
			}

			//este  o mtodo onde  executado nosso programa
	    public static void main(String[] args) {
	        new GUIagenda().setVisible(true);
	    }
	}
