package gui;

import java.awt.EventQueue;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

import produto.Produto;
import produto.RepositorioProdutoBDR;

@SuppressWarnings("serial")
public class GUIproduto extends JFrame {

	private JPanel contentPane;
	
	private Produto produto = null;
	
	private TextField txtNome;
	private TextField txtPreco;
	private TextField txtCodigo;
	private JTextPane txtDescricao;
	private TextField txtQuantidade;
		
		
	
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					GUIproduto frame = new GUIproduto();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public GUIproduto() {
		setTitle("PRODUTO");
		setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		setBounds(100, 100, 501, 499);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(null);
		
		JPanel panel = new JPanel();
		panel.setLayout(null);
		panel.setBorder(new EtchedBorder(EtchedBorder.LOWERED, null, null));
		panel.setBounds(20, 11, 444, 78);
		contentPane.add(panel);
		
		JButton btnCadastrar = new JButton("Cadastrar");
		btnCadastrar.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				CadastrarProduto();
			}
		});
		btnCadastrar.setBounds(15, 13, 100, 48);
		panel.add(btnCadastrar);
		
		JButton btnRemover = new JButton("Remover");
		btnRemover.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				RemoverProduto();
			}
		});
		btnRemover.setBounds(130, 13, 89, 48);
		panel.add(btnRemover);
		
		JButton btnEditar = new JButton("Editar");
		btnEditar.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				EditarProduto();
			}
		});
		btnEditar.setBounds(234, 13, 89, 48);
		panel.add(btnEditar);
		
		JButton list_produto = new JButton("Consultar");
		list_produto.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				ListarProduto();
			}
		});
		list_produto.setBounds(338, 13, 89, 48);
		panel.add(list_produto);
		
		JPanel panel_1 = new JPanel();
		panel_1.setLayout(null);
		panel_1.setBorder(new EtchedBorder(EtchedBorder.LOWERED, null, null));
		panel_1.setBounds(20, 129, 444, 239);
		contentPane.add(panel_1);
		
		Label label = new Label("Nome:");
		label.setBounds(10, 10, 37, 22);
		panel_1.add(label);
		
		Label label_1 = new Label("Pre\u00E7o:");
		label_1.setBounds(10, 38, 37, 22);
		panel_1.add(label_1);
		
		Label label_2 = new Label("C\u00F3digo:");
		label_2.setBounds(10, 66, 44, 22);
		panel_1.add(label_2);
		
		Label label_3 = new Label("Descri\u00E7\u00E3o:");
		label_3.setBounds(10, 121, 62, 22);
		panel_1.add(label_3);
		
		txtNome = new TextField();
		txtNome.setBounds(53, 10, 381, 22);
		panel_1.add(txtNome);
		
		txtPreco = new TextField();
		txtPreco.setBounds(53, 38, 381, 22);
		panel_1.add(txtPreco);
		
		txtCodigo = new TextField();
		txtCodigo.setBounds(53, 66, 381, 22);
		panel_1.add(txtCodigo);
		
		txtDescricao = new JTextPane();
		txtDescricao.setBounds(10, 149, 424, 73);
		panel_1.add(txtDescricao);
		
		Label label_4 = new Label("Quantidade:");
		label_4.setBounds(10, 94, 62, 22);
		panel_1.add(label_4);
		
		txtQuantidade = new TextField();
		txtQuantidade.setBounds(78, 94, 356, 22);
		panel_1.add(txtQuantidade);
		
		JButton btnSair = new JButton("Sair");
		btnSair.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				dispose();
			}
		});
		btnSair.setBounds(189, 389, 89, 48);
		contentPane.add(btnSair);
	}
	
	///Configuracao dos botoes
	void CadastrarProduto() {

		Produto produto = new Produto();
							
		produto.setNome(txtNome.getText());
		produto.setPreco(txtPreco.getText());
		produto.setCodigo(txtCodigo.getText());
		produto.setDescricao(txtDescricao.getText());
		produto.setQuantidade(txtQuantidade.getText()); 
				
		System.out.println("produto: " + produto.toString());
		
	
		
		try {

			// Fachada.getInstance().ProdutoCadastrar(produto); //
			// bronca verificar!!!!
			
			//if (this.produto != null){
				
			
			RepositorioProdutoBDR repo = new RepositorioProdutoBDR();
			repo.ProdutoCadastrar(produto);
			JOptionPane.showMessageDialog(null, "Cadastrado com sucesso!");
			
					
			txtNome.setText(null);
			txtPreco.setText(null);
			txtCodigo.setText(null);
			txtDescricao.setText(null);
			txtQuantidade.setText(null);
			
		}

		catch (Exception e) {
			e.printStackTrace();
			System.out.println("erro");
		}

}

		void EditarProduto(){
			
			try {
				// Fachada.getInstance().ServicoAtualizar(servico);
				
				this.produto.setNome(txtNome.getText());
				this.produto.setPreco(txtPreco.getText());
				this.produto.setCodigo(txtCodigo.getText());
				this.produto.setDescricao(txtDescricao.getText());
				this.produto.setQuantidade(txtQuantidade.getText());
				
				
				if (this.produto != null){
				
					RepositorioProdutoBDR repo = new RepositorioProdutoBDR();
					repo.ProdutoAtualizar(this.produto);
					
					JOptionPane.showMessageDialog(null, "Editado com Sucesso!");
				
				}
				
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		
		void RemoverProduto(){
			
			String codigo;
			codigo = JOptionPane.showInputDialog("Digite o codigo do produto a ser removido");
			
			int result = JOptionPane.showConfirmDialog(null, "Deseja realmente excluir o registro ?");
			if (result == 1){
				RemoverProduto();
			}	
			
			
			try {

				// Fachada.getInstance().ProdutoRemover(produto);
				RepositorioProdutoBDR repo = new RepositorioProdutoBDR();
				repo.ProdutoRemover(codigo);

				JOptionPane.showMessageDialog(null, "Produto removido do Banco de dados!");
				
			} catch (Exception e) {
				e.printStackTrace();
			}

		}

		
		void ListarProduto(){
			
			String codigo = null;
			codigo = JOptionPane
					.showInputDialog("Digite o codigo do produto para editar");


			try {

				//Produto serv = Fachada.getInstance().ServicoProcurar(codigo);
				RepositorioProdutoBDR repo = new RepositorioProdutoBDR();
				Produto prod = repo.ProdutoProcurar(codigo);
				this.produto = prod;
				
				System.out.println("Prod: "+prod.toString());
				
				txtNome.setText(prod.getNome());
				txtPreco.setText(prod.getPreco());
				txtCodigo.setText(prod.getCodigo());
				txtDescricao.setText(prod.getDescricao());
				txtQuantidade.setText(prod.getQuantidade());
							
			}

			catch (Exception e) {
				e.printStackTrace();
			}

		}

	}
