package gui;

import java.awt.EventQueue;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

import servico.RepositorioServicoBDR;
import servico.Servico;

public class GUIservico extends JFrame {
	
	private static final long serialVersionUID = 1L;

	
	private Servico servico = null;
	
	private TextField txtNome;
	private TextField txtPreco;
	private TextField txtCodigo;
	private JTextPane txtDescricao;
	

	private JPanel contentPane;


	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					GUIservico frame = new GUIservico();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public GUIservico() {
		setTitle("SERVICO");
		setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		setBounds(100, 100, 502, 498);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(null);
		
		JPanel panel = new JPanel();
		panel.setBorder(new EtchedBorder(EtchedBorder.LOWERED, null, null));
		panel.setBounds(18, 11, 444, 78);
		contentPane.add(panel);
		panel.setLayout(null);
		
		JButton cad_servico = new JButton("Cadastrar");
		cad_servico.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				CadastrarServico();		
			}
		});
		cad_servico.setBounds(15, 13, 100, 48);
		panel.add(cad_servico);
		
		JButton rem_servico = new JButton("Remover");
		rem_servico.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				RemoverServico();
			}
		});
		rem_servico.setBounds(130, 13, 89, 48);
		panel.add(rem_servico);
		
		JButton edit_servico = new JButton("Editar");
		edit_servico.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				EditarServico();
			}
		});
		edit_servico.setBounds(234, 13, 89, 48);
		panel.add(edit_servico);
		
		JButton list_servico = new JButton("Consultar");
		list_servico.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				ListarServico();
			}
		});
		list_servico.setBounds(338, 13, 89, 48);
		panel.add(list_servico);
		
		JPanel panel_1 = new JPanel();
		panel_1.setBorder(new EtchedBorder(EtchedBorder.LOWERED, null, null));
		panel_1.setBounds(18, 149, 444, 208);
		contentPane.add(panel_1);
		panel_1.setLayout(null);
		
		Label label = new Label("Nome:");
		label.setBounds(10, 10, 37, 22);
		panel_1.add(label);
		
		Label label_1 = new Label("Pre\u00E7o:");
		label_1.setBounds(10, 38, 37, 22);
		panel_1.add(label_1);
		
		Label label_2 = new Label("C\u00F3digo:");
		label_2.setBounds(10, 66, 44, 22);
		panel_1.add(label_2);
		
		Label label_3 = new Label("Descri\u00E7\u00E3o:");
		label_3.setBounds(10, 94, 62, 22);
		panel_1.add(label_3);
		
		txtNome = new TextField();
		txtNome.setBounds(53, 10, 381, 22);
		panel_1.add(txtNome);
		
		txtPreco = new TextField();
		txtPreco.setBounds(53, 38, 381, 22);
		panel_1.add(txtPreco);
		
		txtCodigo = new TextField();
		txtCodigo.setBounds(53, 66, 381, 22);
		panel_1.add(txtCodigo);
		
		txtDescricao = new JTextPane(); 
		txtDescricao.setBounds(10, 122, 424, 73);
		panel_1.add(txtDescricao);
		
		JButton btnSair = new JButton("Sair");
		btnSair.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				dispose();
			}
		});
		btnSair.setBounds(190, 386, 89, 48);
		contentPane.add(btnSair);
	}
	
	///Configuracao dos botoes
	
	void CadastrarServico() {

		Servico servico = new Servico();
		
								
		servico.setNome(txtNome.getText());
		servico.setPreco(txtPreco.getText());
		servico.setCodigo(txtCodigo.getText());
		servico.setDescricao(txtDescricao.getText());
		
		
		System.out.println("servico: " + servico.toString());
		
	
		
		try {

			// Fachada.getInstance().ServicoCadastrar(servico); //
			// bronca verificar!!!!
			
			//if (this.servico != null){
				
			
			RepositorioServicoBDR repo = new RepositorioServicoBDR();
			repo.ServicoCadastrar(servico);
			JOptionPane.showMessageDialog(null, "Cadastrado com sucesso!");
			
			
			
			txtNome.setText(null);
			txtPreco.setText(null);
			txtCodigo.setText(null);
			txtDescricao.setText(null);
			
		}

		catch (Exception e) {
			e.printStackTrace();
		}

}

		
	void EditarServico(){
		
		try {
			// Fachada.getInstance().ServicoAtualizar(servico);
			
			this.servico.setNome(txtNome.getText());
			this.servico.setPreco(txtPreco.getText());
			this.servico.setCodigo(txtCodigo.getText());
			this.servico.setDescricao(txtDescricao.getText());
			
			
			
			if (this.servico != null){
			
				RepositorioServicoBDR repo = new RepositorioServicoBDR();
				repo.ServicoAtualizar(this.servico);
				
				JOptionPane.showMessageDialog(null, "Editado com Sucesso!");
			
			}
			
		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	void RemoverServico(){
		
		String codigo;
		codigo = JOptionPane.showInputDialog("Digite o codigo do servido a ser removido");
		
		int result = JOptionPane.showConfirmDialog(null, "Deseja realmente excluir o registro?");
				if (result == 1){
					RemoverServico();
		}
				
		
		try {

			// Fachada.getInstance().ServicoRemover(servico);
			RepositorioServicoBDR repo = new RepositorioServicoBDR();
			repo.ServicoRemover(codigo);
			
			JOptionPane.showMessageDialog(null, "Cliente removido do Banco de dados!");
  		 	

		} catch (Exception e) {
			e.printStackTrace();
		}

	}
	
	void ListarServico(){
		
		String codigo = null;
		codigo = JOptionPane
				.showInputDialog("Digite o codigo do servico para editar");


		try {

			//Servico serv = Fachada.getInstance().ServicoProcurar(codigo);
			RepositorioServicoBDR repo = new RepositorioServicoBDR();
			Servico serv = repo.ServicoProcurar(codigo);
			this.servico = serv;
			
			System.out.println("Serv: "+serv.toString());
			
			txtNome.setText(serv.getNome());
			txtPreco.setText(serv.getPreco());
			txtCodigo.setText(serv.getCodigo());
			txtDescricao.setText(serv.getDescricao());
			
						
		}

		catch (Exception e) {
			e.printStackTrace();
		}

	}

}
