package servico;

import java.sql.ResultSet;
import java.util.ArrayList;

import javax.swing.JOptionPane;

import com.mysql.jdbc.Connection;

import conexao.ConectarComBanco;


public class RepositorioServicoBDR implements IRepositorioServico {
	
	@Override
	public void ServicoCadastrar(Servico servico) {

		String sql = "INSERT INTO servico (nome, preco, descricao, codigo) VALUES (?,?,?,?)"; 
		
		java.sql.PreparedStatement prstm = null;
		Connection conn = null;
		
		try{
			
			conn = ConectarComBanco.ConectarComMysql();
			prstm = conn.prepareStatement(sql);
			prstm.setString(1, servico.getNome());
			prstm.setString(2, servico.getPreco());
			prstm.setString(3, servico.getDescricao());
			prstm.setString(4, servico.getCodigo());
			
		
			prstm.execute();
		
		}catch (Exception e){
			
			e.printStackTrace();
			
		}finally{
			
			try{
				
				if (prstm != null){
					prstm.close();
				}
				if (conn != null){
					conn.close();
				}
			}catch (Exception e){
				e.printStackTrace();
			}
			
		}
		
	}

	@Override
	public void ServicoRemover(String codigo) {

		String sql = "DELETE FROM servico WHERE codigo = ?; " ;
		
		java.sql.PreparedStatement prstm = null;
		Connection conn = null; 
		
		JOptionPane.showMessageDialog(null, "Cliente removido da base de dados!");
		
		try{
			
			conn = ConectarComBanco.ConectarComMysql();
			prstm = conn.clientPrepareStatement(sql);
			prstm.setString(1, codigo);
			prstm.execute();
			
		}catch(Exception e){
			//e.printStackTrace();
			System.out.println("ERRO: " + e);
			
		}
		
		
	}	
	
	@Override
	public Servico ServicoProcurar (String codigo){
		
		Servico servico = new Servico();
		
		Connection conn = null;
		java.sql.PreparedStatement prstm = null;
		ResultSet resultSet = null;

		
		String sql = "SELECT * FROM servico WHERE codigo='" + codigo + "' LIMIT 1; ";
		System.out.println("SQL: "+sql);
		
		try {
			conn = ConectarComBanco.ConectarComMysql();
			prstm = conn.prepareStatement(sql);
			resultSet = prstm.executeQuery();
			while (resultSet.next()) {
				
				servico.setId(resultSet.getInt("idservico"));
				servico.setNome(resultSet.getString("nome"));
				servico.setPreco(resultSet.getString("preco"));
				servico.setCodigo(resultSet.getString("codigo"));
				servico.setDescricao(resultSet.getString("descricao"));
				
				
			}
		} catch (Exception e) {
			System.out.println("ERRO:"+e);

		}
		return servico;

	}
		
	    

	@Override
	public void ServicoAtualizar(Servico servico) {
		
		String sql = "UPDATE servico SET nome = ?, preco = ?,  descricao = ?, codigo = ?" + "WHERE idservico = ?;";
		
		java.sql.PreparedStatement prstm = null;
		Connection conn = null;
		
		JOptionPane.showMessageDialog(null, "Editado com sucesso!");
		
		try{
					
			conn = ConectarComBanco.ConectarComMysql();
			prstm = conn.prepareStatement(sql);
			prstm.setString(1, servico.getNome());
			prstm.setString(2, servico.getPreco());
			prstm.setString(3, servico.getDescricao());
			prstm.setString(4, servico.getCodigo());
			
			prstm.setInt(5, servico.getId());
			
	
			prstm.execute();
			
		}catch(Exception e){
			System.out.println("ERRO: "+e);
		}
		
	}

		@Override
		public ArrayList<Servico> ServicoListar() {
			
			String sql = "SELECT * FROM servico";

			Connection conn = null;
			java.sql.PreparedStatement prstm = null;
			ResultSet resultSet = null;
			
			

			ArrayList<Servico> listaServico = new ArrayList<Servico>();

			try {
				conn = ConectarComBanco.ConectarComMysql();
				prstm = conn.prepareStatement(sql);
				resultSet = prstm.executeQuery();

				while (resultSet.next()) {

					Servico servico = new Servico(
							resultSet.getString("nome"),
							resultSet.getString("preco"),
							resultSet.getString("codigo"),
							resultSet.getString("descricao"));
							

					listaServico.add(servico);
					System.out.println(resultSet.getString("nome") + " "
							+ resultSet.getString("codigo"));

				}

			}

			catch (Exception e) {
				e.printStackTrace();
			}

			return listaServico;
		}
		
}