/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package br.projecao.spe.modelo;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 *
 * @author Desenvolvimento
 */
@Entity
@Table(name = "cronograma")
@NamedQueries({
    @NamedQuery(name = "Cronograma.findAll", query = "SELECT c FROM Cronograma c"),
    @NamedQuery(name = "Cronograma.findByIdcronograma", query = "SELECT c FROM Cronograma c WHERE c.cronogramaPK.idcronograma = :idcronograma"),
    @NamedQuery(name = "Cronograma.findByIdplanoEnsino", query = "SELECT c FROM Cronograma c WHERE c.cronogramaPK.idplanoEnsino = :idplanoEnsino"),
    @NamedQuery(name = "Cronograma.findByEncontro", query = "SELECT c FROM Cronograma c WHERE c.encontro = :encontro"),
    @NamedQuery(name = "Cronograma.findByData", query = "SELECT c FROM Cronograma c WHERE c.data = :data"),
    @NamedQuery(name = "Cronograma.findByAtividade", query = "SELECT c FROM Cronograma c WHERE c.atividade = :atividade")})
public class Cronograma implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected CronogramaPK cronogramaPK;
    @Basic(optional = false)
    @Column(name = "encontro")
    private int encontro;
    @Basic(optional = false)
    @Column(name = "data")
    @Temporal(TemporalType.DATE)
    private Date data;
    @Basic(optional = false)
    @Column(name = "atividade")
    private String atividade;
    @JoinColumn(name = "idplano_ensino", referencedColumnName = "idplano_ensino", insertable = false, updatable = false)
    @ManyToOne(optional = false)
    private PlanoProfessor planoProfessor;

    public Cronograma() {
    }

    public Cronograma(CronogramaPK cronogramaPK) {
        this.cronogramaPK = cronogramaPK;
    }

    public Cronograma(CronogramaPK cronogramaPK, int encontro, Date data, String atividade) {
        this.cronogramaPK = cronogramaPK;
        this.encontro = encontro;
        this.data = data;
        this.atividade = atividade;
    }

    public Cronograma(int idcronograma, int idplanoEnsino) {
        this.cronogramaPK = new CronogramaPK(idcronograma, idplanoEnsino);
    }

    public CronogramaPK getCronogramaPK() {
        return cronogramaPK;
    }

    public void setCronogramaPK(CronogramaPK cronogramaPK) {
        this.cronogramaPK = cronogramaPK;
    }

    public int getEncontro() {
        return encontro;
    }

    public void setEncontro(int encontro) {
        this.encontro = encontro;
    }

    public Date getData() {
        return data;
    }

    public void setData(Date data) {
        this.data = data;
    }

    public String getAtividade() {
        return atividade;
    }

    public void setAtividade(String atividade) {
        this.atividade = atividade;
    }

    public PlanoProfessor getPlanoProfessor() {
        return planoProfessor;
    }

    public void setPlanoProfessor(PlanoProfessor planoProfessor) {
        this.planoProfessor = planoProfessor;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (cronogramaPK != null ? cronogramaPK.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof Cronograma)) {
            return false;
        }
        Cronograma other = (Cronograma) object;
        if ((this.cronogramaPK == null && other.cronogramaPK != null) || (this.cronogramaPK != null && !this.cronogramaPK.equals(other.cronogramaPK))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "br.projecao.spe.modelo.Cronograma[cronogramaPK=" + cronogramaPK + "]";
    }

}
