/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package br.projecao.spe.modelo;

import java.io.Serializable;
import java.util.Collection;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;

/**
 *
 * @author Desenvolvimento
 */
@Entity
@Table(name = "disciplina")
@NamedQueries({
    @NamedQuery(name = "Disciplina.findAll", query = "SELECT d FROM Disciplina d"),
    @NamedQuery(name = "Disciplina.findByIddisciplina", query = "SELECT d FROM Disciplina d WHERE d.iddisciplina = :iddisciplina"),
    @NamedQuery(name = "Disciplina.findByCodigo", query = "SELECT d FROM Disciplina d WHERE d.codigo = :codigo"),
    @NamedQuery(name = "Disciplina.findByDescricao", query = "SELECT d FROM Disciplina d WHERE d.descricao = :descricao"),
    @NamedQuery(name = "Disciplina.findByCargaHoraria", query = "SELECT d FROM Disciplina d WHERE d.cargaHoraria = :cargaHoraria"),
    @NamedQuery(name = "Disciplina.findByPeriodo", query = "SELECT d FROM Disciplina d WHERE d.periodo = :periodo")})
public class Disciplina implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Basic(optional = false)
    @Column(name = "iddisciplina")
    private Integer iddisciplina;
    @Basic(optional = false)
    @Column(name = "codigo")
    private String codigo;
    @Basic(optional = false)
    @Column(name = "descricao")
    private String descricao;
    @Basic(optional = false)
    @Column(name = "carga_horaria")
    private int cargaHoraria;
    @Basic(optional = false)
    @Column(name = "periodo")
    private int periodo;
    @JoinTable(name = "disciplina_has_curso", joinColumns = {
        @JoinColumn(name = "iddisciplina", referencedColumnName = "iddisciplina")}, inverseJoinColumns = {
        @JoinColumn(name = "idcurso", referencedColumnName = "idcurso")})
    @ManyToMany
    private Collection<Curso> cursoCollection;
    @ManyToMany(mappedBy = "disciplinaCollection")
    private Collection<Usuario> usuarioCollection;
    @JoinTable(name = "disciplina_has_disciplina", joinColumns = {
        @JoinColumn(name = "iddisciplina", referencedColumnName = "iddisciplina")}, inverseJoinColumns = {
        @JoinColumn(name = "iddisciplina_pre_requesito", referencedColumnName = "iddisciplina")})
    @ManyToMany
    private Collection<Disciplina> disciplinaCollection;
    @ManyToMany(mappedBy = "disciplinaCollection")
    private Collection<Disciplina> disciplinaCollection1;
    @OneToMany(cascade = CascadeType.ALL, mappedBy = "iddisciplina")
    private Collection<PlanoEnsino> planoEnsinoCollection;

    public Disciplina() {
    }

    public Disciplina(Integer iddisciplina) {
        this.iddisciplina = iddisciplina;
    }

    public Disciplina(Integer iddisciplina, String codigo, String descricao, int cargaHoraria, int periodo) {
        this.iddisciplina = iddisciplina;
        this.codigo = codigo;
        this.descricao = descricao;
        this.cargaHoraria = cargaHoraria;
        this.periodo = periodo;
    }

    public Integer getIddisciplina() {
        return iddisciplina;
    }

    public void setIddisciplina(Integer iddisciplina) {
        this.iddisciplina = iddisciplina;
    }

    public String getCodigo() {
        return codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public String getDescricao() {
        return descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public int getCargaHoraria() {
        return cargaHoraria;
    }

    public void setCargaHoraria(int cargaHoraria) {
        this.cargaHoraria = cargaHoraria;
    }

    public int getPeriodo() {
        return periodo;
    }

    public void setPeriodo(int periodo) {
        this.periodo = periodo;
    }

    public Collection<Curso> getCursoCollection() {
        return cursoCollection;
    }

    public void setCursoCollection(Collection<Curso> cursoCollection) {
        this.cursoCollection = cursoCollection;
    }

    public Collection<Usuario> getUsuarioCollection() {
        return usuarioCollection;
    }

    public void setUsuarioCollection(Collection<Usuario> usuarioCollection) {
        this.usuarioCollection = usuarioCollection;
    }

    public Collection<Disciplina> getDisciplinaCollection() {
        return disciplinaCollection;
    }

    public void setDisciplinaCollection(Collection<Disciplina> disciplinaCollection) {
        this.disciplinaCollection = disciplinaCollection;
    }

    public Collection<Disciplina> getDisciplinaCollection1() {
        return disciplinaCollection1;
    }

    public void setDisciplinaCollection1(Collection<Disciplina> disciplinaCollection1) {
        this.disciplinaCollection1 = disciplinaCollection1;
    }

    public Collection<PlanoEnsino> getPlanoEnsinoCollection() {
        return planoEnsinoCollection;
    }

    public void setPlanoEnsinoCollection(Collection<PlanoEnsino> planoEnsinoCollection) {
        this.planoEnsinoCollection = planoEnsinoCollection;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (iddisciplina != null ? iddisciplina.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof Disciplina)) {
            return false;
        }
        Disciplina other = (Disciplina) object;
        if ((this.iddisciplina == null && other.iddisciplina != null) || (this.iddisciplina != null && !this.iddisciplina.equals(other.iddisciplina))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "br.projecao.spe.modelo.Disciplina[iddisciplina=" + iddisciplina + "]";
    }

}
