/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package br.projecao.spe.modelo;

import java.io.Serializable;
import java.util.Collection;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;

/**
 *
 * @author Desenvolvimento
 */
@Entity
@Table(name = "plano_professor")
@NamedQueries({
    @NamedQuery(name = "PlanoProfessor.findAll", query = "SELECT p FROM PlanoProfessor p"),
    @NamedQuery(name = "PlanoProfessor.findByIdplanoEnsino", query = "SELECT p FROM PlanoProfessor p WHERE p.idplanoEnsino = :idplanoEnsino"),
    @NamedQuery(name = "PlanoProfessor.findByTurma", query = "SELECT p FROM PlanoProfessor p WHERE p.turma = :turma"),
    @NamedQuery(name = "PlanoProfessor.findByMetodologia", query = "SELECT p FROM PlanoProfessor p WHERE p.metodologia = :metodologia"),
    @NamedQuery(name = "PlanoProfessor.findByRecursos", query = "SELECT p FROM PlanoProfessor p WHERE p.recursos = :recursos"),
    @NamedQuery(name = "PlanoProfessor.findByAvaliacao", query = "SELECT p FROM PlanoProfessor p WHERE p.avaliacao = :avaliacao"),
    @NamedQuery(name = "PlanoProfessor.findByObservacao", query = "SELECT p FROM PlanoProfessor p WHERE p.observacao = :observacao"),
    @NamedQuery(name = "PlanoProfessor.findByPeriodoMinistrado", query = "SELECT p FROM PlanoProfessor p WHERE p.periodoMinistrado = :periodoMinistrado")})
public class PlanoProfessor implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Basic(optional = false)
    @Column(name = "idplano_ensino")
    private Integer idplanoEnsino;
    @Basic(optional = false)
    @Column(name = "turma")
    private String turma;
    @Basic(optional = false)
    @Column(name = "metodologia")
    private String metodologia;
    @Basic(optional = false)
    @Column(name = "recursos")
    private String recursos;
    @Basic(optional = false)
    @Column(name = "avaliacao")
    private String avaliacao;
    @Basic(optional = false)
    @Column(name = "observacao")
    private String observacao;
    @Basic(optional = false)
    @Column(name = "periodo_ministrado")
    private String periodoMinistrado;
    @OneToMany(cascade = CascadeType.ALL, mappedBy = "planoProfessor")
    private Collection<Cronograma> cronogramaCollection;
    @JoinColumn(name = "idusuario", referencedColumnName = "idusuario")
    @ManyToOne(optional = false)
    private Usuario idusuario;
    @JoinColumn(name = "idplano_ensino", referencedColumnName = "idplano_ensino", insertable = false, updatable = false)
    @OneToOne(optional = false)
    private PlanoEnsino planoEnsino;

    public PlanoProfessor() {
    }

    public PlanoProfessor(Integer idplanoEnsino) {
        this.idplanoEnsino = idplanoEnsino;
    }

    public PlanoProfessor(Integer idplanoEnsino, String turma, String metodologia, String recursos, String avaliacao, String observacao, String periodoMinistrado) {
        this.idplanoEnsino = idplanoEnsino;
        this.turma = turma;
        this.metodologia = metodologia;
        this.recursos = recursos;
        this.avaliacao = avaliacao;
        this.observacao = observacao;
        this.periodoMinistrado = periodoMinistrado;
    }

    public Integer getIdplanoEnsino() {
        return idplanoEnsino;
    }

    public void setIdplanoEnsino(Integer idplanoEnsino) {
        this.idplanoEnsino = idplanoEnsino;
    }

    public String getTurma() {
        return turma;
    }

    public void setTurma(String turma) {
        this.turma = turma;
    }

    public String getMetodologia() {
        return metodologia;
    }

    public void setMetodologia(String metodologia) {
        this.metodologia = metodologia;
    }

    public String getRecursos() {
        return recursos;
    }

    public void setRecursos(String recursos) {
        this.recursos = recursos;
    }

    public String getAvaliacao() {
        return avaliacao;
    }

    public void setAvaliacao(String avaliacao) {
        this.avaliacao = avaliacao;
    }

    public String getObservacao() {
        return observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public String getPeriodoMinistrado() {
        return periodoMinistrado;
    }

    public void setPeriodoMinistrado(String periodoMinistrado) {
        this.periodoMinistrado = periodoMinistrado;
    }

    public Collection<Cronograma> getCronogramaCollection() {
        return cronogramaCollection;
    }

    public void setCronogramaCollection(Collection<Cronograma> cronogramaCollection) {
        this.cronogramaCollection = cronogramaCollection;
    }

    public Usuario getIdusuario() {
        return idusuario;
    }

    public void setIdusuario(Usuario idusuario) {
        this.idusuario = idusuario;
    }

    public PlanoEnsino getPlanoEnsino() {
        return planoEnsino;
    }

    public void setPlanoEnsino(PlanoEnsino planoEnsino) {
        this.planoEnsino = planoEnsino;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (idplanoEnsino != null ? idplanoEnsino.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof PlanoProfessor)) {
            return false;
        }
        PlanoProfessor other = (PlanoProfessor) object;
        if ((this.idplanoEnsino == null && other.idplanoEnsino != null) || (this.idplanoEnsino != null && !this.idplanoEnsino.equals(other.idplanoEnsino))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "br.projecao.spe.modelo.PlanoProfessor[idplanoEnsino=" + idplanoEnsino + "]";
    }

}
